/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.tileentities;

import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.init.RecipeLibrary;
import com.aranaira.arcanearchives.inventory.handlers.ITrackingHandler;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketGemCutters;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IBrazierRouting;
import com.aranaira.arcanearchives.tileentities.interfaces.IManifestTileEntity;
import com.aranaira.arcanearchives.util.ItemUtils;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class GemCuttersTableTileEntity
extends ImmanenceTileEntity
implements IManifestTileEntity,
IBrazierRouting {
    private final TrackingGCTHandler inventory = new TrackingGCTHandler(18);
    private final IItemHandlerModifiable outputInventory = new ItemStackHandler(1);
    public static final int RECIPE_PAGE_LIMIT = 7;
    private IGCTRecipe currentRecipe = RecipeLibrary.RADIANT_DUST_RECIPE;
    private IGCTRecipe lastRecipe;
    private IGCTRecipe penultimateRecipe;
    private int page;
    public static final ResourceLocation INVALID = new ResourceLocation("arcanearchives", "invalid_gct_recipe");

    public GemCuttersTableTileEntity() {
        super("gemcutterstable");
    }

    @Override
    public String getDescriptor() {
        return "Gem Cutter's Table";
    }

    @Override
    public String getChestName() {
        return "";
    }

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public IItemHandlerModifiable getOutputInventory() {
        return this.outputInventory;
    }

    public void setRecipe(ResourceLocation name) {
        this.currentRecipe = GCTRecipeList.instance.getRecipe(name);
        this.defaultServerSideUpdate();
    }

    public void setRecipe(int index) {
        this.manuallySetRecipe(index);
        this.func_70296_d();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.clientSideUpdate();
        } else if (this.field_145850_b != null) {
            this.defaultServerSideUpdate();
        }
    }

    public void manuallySetRecipe(int index) {
        this.currentRecipe = GCTRecipeList.instance.getRecipeByIndex(index);
    }

    public void clientSideUpdate() {
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return;
        }
        ResourceLocation loc = INVALID;
        if (this.currentRecipe != null) {
            loc = this.currentRecipe.getName();
        }
        PacketGemCutters.ChangeRecipe packet = new PacketGemCutters.ChangeRecipe(loc, this.func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
        Networking.CHANNEL.sendToServer((IMessage)packet);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public IGCTRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Deprecated
    public boolean hasCurrentRecipe() {
        return this.currentRecipe != null;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.manuallySetRecipe(compound.func_74762_e("recipe"));
    }

    public IGCTRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        if (this.currentRecipe != null) {
            compound.func_74768_a("recipe", this.currentRecipe.getIndex());
        }
        return compound;
    }

    public void setLastRecipe(IGCTRecipe lastRecipe) {
        this.lastRecipe = lastRecipe;
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public IGCTRecipe getPenultimateRecipe() {
        return this.penultimateRecipe;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public void updatePenultimateRecipe() {
        this.penultimateRecipe = this.lastRecipe;
    }

    @Override
    @Nonnull
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void previousPage() {
        if (this.getPage() > 0) {
            this.setPage(this.page - 1);
        } else {
            int page = GCTRecipeList.instance.size() / 7;
            if (GCTRecipeList.instance.size() % 7 == 0) {
                --page;
            }
            this.setPage(page);
        }
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void nextPage() {
        if (GCTRecipeList.instance.size() > (this.page + 1) * 7) {
            this.setPage(this.page + 1);
        } else {
            this.setPage(0);
        }
    }

    public Int2IntOpenHashMap getOrCalculateReference(boolean force) {
        if (force) {
            this.inventory.manualRecount();
        }
        return this.inventory.getItemReference();
    }

    @Override
    public Int2IntOpenHashMap getOrCalculateReference() {
        return this.getOrCalculateReference(false);
    }

    @Override
    public IBrazierRouting.BrazierRoutingType getRoutingType() {
        return IBrazierRouting.BrazierRoutingType.GCT;
    }

    @Override
    public boolean isTileInvalid() {
        return this.func_145837_r();
    }

    @Override
    public int countEmptySlots() {
        int empty = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ++empty;
        }
        return empty;
    }

    @Override
    public int totalEmptySlots() {
        return this.inventory.getEmptyCount();
    }

    @Override
    public int totalSlots() {
        return this.inventory.getSlots();
    }

    @Override
    public int slotMultiplier() {
        return 1;
    }

    @Override
    public ItemStack acceptStack(ItemStack stack, boolean simulate) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack inSlot = this.inventory.getStackInSlot(i);
            if (!ItemUtils.areStacksEqualIgnoreSize(stack, inSlot) || !(stack = this.inventory.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return stack;
        }
        this.func_70296_d();
        return stack;
    }

    public class TrackingGCTHandler
    extends ItemStackHandler
    implements ITrackingHandler {
        private Int2IntOpenHashMap itemReference;
        private int emptySlots;
        private boolean invalid;

        public TrackingGCTHandler(int size) {
            super(size);
            this.itemReference = new Int2IntOpenHashMap();
            this.emptySlots = 0;
            this.invalid = false;
            this.itemReference.defaultReturnValue(0);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            if (GemCuttersTableTileEntity.this.field_145850_b == null || !((GemCuttersTableTileEntity)GemCuttersTableTileEntity.this).field_145850_b.field_72995_K) {
                this.manualRecount();
            }
        }

        @Override
        public Int2IntOpenHashMap getItemReference() {
            if (this.invalid) {
                this.invalid = false;
                this.manualRecount();
            }
            return this.itemReference;
        }

        @Override
        public int totalSlots() {
            return this.getSlots();
        }

        @Override
        public int getEmptyCount() {
            return this.emptySlots;
        }

        @Override
        public void setEmptyCount(int amount) {
            this.emptySlots = amount;
        }

        @Override
        public void incrementEmptyCount() {
            ++this.emptySlots;
        }

        @Override
        public void decrementEmptyCount() {
            --this.emptySlots;
        }

        @Override
        public void invalidate() {
            this.invalid = true;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            this.invalidate();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!simulate) {
                this.invalidate();
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (!simulate) {
                this.invalidate();
            }
            return result;
        }
    }

    public static class Tags {
        public static final String RECIPE = "recipe";
    }
}

