/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.recipe;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreIngredient;

public class IngredientStack {
    private final Ingredient ingredient;
    private int count;
    @Nullable
    private final NBTTagCompound nbt;

    public IngredientStack(ItemStack stack) {
        this.ingredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
        this.count = stack.func_190916_E();
        this.nbt = stack.func_77978_p();
    }

    public IngredientStack(Item item, int count) {
        this(item, count, null);
    }

    public IngredientStack(Item item, int count, NBTTagCompound nbt) {
        this.ingredient = Ingredient.func_193367_a((Item)item);
        this.count = count;
        this.nbt = nbt;
    }

    public IngredientStack(Item item) {
        this(item, 1, null);
    }

    public IngredientStack(String item, int count) {
        this(item, count, null);
    }

    public IngredientStack(String item, int count, NBTTagCompound nbt) {
        this.ingredient = new OreIngredient(item);
        this.count = count;
        this.nbt = nbt;
    }

    public IngredientStack(String item) {
        this(item, 1, null);
    }

    public IngredientStack(Ingredient ingredient, int count) {
        this(ingredient, count, null);
    }

    public IngredientStack(Ingredient ingredient, int count, NBTTagCompound nbt) {
        this.ingredient = ingredient;
        this.count = count;
        this.nbt = nbt;
    }

    public IngredientStack(Ingredient ingredient) {
        this(ingredient, 1, null);
    }

    public IngredientStack(Block item, int count) {
        this(item, count, null);
    }

    public IngredientStack(Block block, int count, NBTTagCompound nbt) {
        this.ingredient = Ingredient.func_193367_a((Item)Item.func_150898_a((Block)block));
        this.count = count;
        this.nbt = nbt;
    }

    public IngredientStack(Block item) {
        this(item, 1, null);
    }

    public ItemStack[] getMatchingStacks() {
        return this.ingredient.func_193365_a();
    }

    public boolean apply(@Nullable ItemStack p_apply_1_) {
        boolean res = this.ingredient.apply(p_apply_1_);
        if (this.nbt != null && p_apply_1_ != null) {
            return res && this.nbt.equals((Object)p_apply_1_.func_77978_p());
        }
        return res;
    }

    public IntList getValidItemStacksPacked() {
        return this.ingredient.func_194139_b();
    }

    public boolean isSimple() {
        return this.ingredient.isSimple();
    }

    public int getCount() {
        return this.count;
    }

    public void shrink(int amount) {
        this.count -= amount;
    }

    public void grow(int amount) {
        this.count += amount;
    }

    public void shrink() {
        this.shrink(1);
    }

    public void grow() {
        this.grow(1);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Nullable
    public NBTTagCompound getNBT() {
        return this.nbt;
    }

    public List<ItemStack> getMatchingStacksWithSizes() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : this.getMatchingStacks()) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(this.getCount());
            result.add(copy);
        }
        return result;
    }
}

