/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.network;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.inventory.ContainerRadiantChest;
import com.aranaira.arcanearchives.network.Handlers;
import com.aranaira.arcanearchives.network.Messages;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.util.NetworkUtils;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketConfirmTransaction;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketRadiantChest {

    public static class MessageSyncExtendedSlotContents
    implements IMessage {
        private int windowId = 0;
        private int slot = 0;
        private ItemStack stack = ItemStack.field_190927_a;

        public MessageSyncExtendedSlotContents() {
        }

        public MessageSyncExtendedSlotContents(int windowId, int slot, ItemStack stack) {
            this.windowId = windowId;
            this.slot = slot;
            this.stack = stack.func_77946_l();
        }

        public void fromBytes(ByteBuf buf) {
            this.windowId = buf.readByte();
            this.slot = buf.readInt();
            try {
                this.stack = NetworkUtils.readExtendedItemStack(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.windowId);
            buf.writeInt(this.slot);
            NetworkUtils.writeExtendedItemStack(buf, this.stack);
        }

        public static class Handler
        implements IMessageHandler<MessageSyncExtendedSlotContents, IMessage> {
            @SideOnly(value=Side.CLIENT)
            public IMessage onMessage(final MessageSyncExtendedSlotContents message, MessageContext ctx) {
                Minecraft mc = FMLClientHandler.instance().getClient();
                EntityPlayerSP player = mc.field_71439_g;
                if (player == null) {
                    return null;
                }
                mc.func_152344_a(new Runnable((EntityPlayer)player){
                    final /* synthetic */ EntityPlayer val$player;
                    {
                        this.val$player = entityPlayer;
                    }

                    @Override
                    public void run() {
                        this.processMessage(message, this.val$player);
                    }
                });
                return null;
            }

            public void processMessage(MessageSyncExtendedSlotContents message, EntityPlayer player) {
                if (player.field_71070_bA instanceof ContainerRadiantChest && message.windowId == player.field_71070_bA.field_75152_c) {
                    ((Slot)player.field_71070_bA.field_75151_b.get(message.slot)).func_75215_d(message.stack);
                }
            }
        }
    }

    public static class MessageClickWindowExtended
    implements IMessage {
        private int windowId;
        private int slot;
        private int mouseButton;
        private short transactionId;
        private ItemStack clickedItem = ItemStack.field_190927_a;
        private ClickType mode;

        public MessageClickWindowExtended() {
        }

        public MessageClickWindowExtended(int windowId, int slot, int mouseButton, ClickType mode, ItemStack clickedItem, short transactionId) {
            this.windowId = windowId;
            this.slot = slot;
            this.mouseButton = mouseButton;
            this.mode = mode;
            this.clickedItem = clickedItem;
            this.transactionId = transactionId;
        }

        public void fromBytes(ByteBuf buf) {
            this.windowId = buf.readByte();
            this.slot = buf.readInt();
            this.mouseButton = buf.readByte();
            this.transactionId = buf.readShort();
            this.mode = ClickType.values()[buf.readInt()];
            try {
                this.clickedItem = NetworkUtils.readExtendedItemStack(buf);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeByte(this.windowId);
            buf.writeInt(this.slot);
            buf.writeByte(this.mouseButton);
            buf.writeShort((int)this.transactionId);
            buf.writeInt(this.mode.ordinal());
            NetworkUtils.writeExtendedItemStackFromClientToServer(buf, this.clickedItem);
        }

        public static class Handler
        implements IMessageHandler<MessageClickWindowExtended, IMessage> {
            public IMessage onMessage(final MessageClickWindowExtended message, MessageContext ctx) {
                final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (player == null) {
                    return null;
                }
                player.func_71121_q().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        this.processMessage(message, player);
                    }
                });
                return null;
            }

            public void processMessage(MessageClickWindowExtended message, EntityPlayerMP player) {
                player.func_143004_u();
                Container container = player.field_71070_bA;
                if (container.field_75152_c == message.windowId && container.func_75129_b((EntityPlayer)player)) {
                    if (player.func_175149_v()) {
                        if (container instanceof ContainerRadiantChest) {
                            ((ContainerRadiantChest)container).syncInventory(player);
                        } else {
                            NonNullList nonnulllist = NonNullList.func_191196_a();
                            for (int i = 0; i < container.field_75151_b.size(); ++i) {
                                nonnulllist.add((Object)((Slot)container.field_75151_b.get(i)).func_75211_c());
                            }
                            player.func_71110_a(container, nonnulllist);
                        }
                    } else {
                        ItemStack itemstack2 = container.func_184996_a(message.slot, message.mouseButton, message.mode, (EntityPlayer)player);
                        if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)message.clickedItem, (ItemStack)itemstack2)) {
                            player.field_71135_a.func_147359_a((Packet)new SPacketConfirmTransaction(message.windowId, message.transactionId, true));
                            player.field_71137_h = true;
                            player.field_71070_bA.func_75142_b();
                            player.func_71113_k();
                            player.field_71137_h = false;
                        } else if (container instanceof ContainerRadiantChest) {
                            ((ContainerRadiantChest)container).syncInventory(player);
                        } else {
                            NonNullList nonnulllist1 = NonNullList.func_191196_a();
                            for (int j = 0; j < container.field_75151_b.size(); ++j) {
                                ItemStack itemstack = ((Slot)container.field_75151_b.get(j)).func_75211_c();
                                ItemStack itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack;
                                nonnulllist1.add((Object)itemstack1);
                            }
                            player.func_71110_a(container, nonnulllist1);
                        }
                    }
                }
            }
        }
    }

    public static class ToggleBrazier
    implements IMessage {
        private UUID networkId = DataHelper.INVALID;
        private UUID tileId = DataHelper.INVALID;

        public ToggleBrazier() {
        }

        public ToggleBrazier(UUID networkId, UUID tileId) {
            this.networkId = networkId;
            this.tileId = tileId;
        }

        public void fromBytes(ByteBuf buf) {
            long most = buf.readLong();
            long least = buf.readLong();
            this.networkId = new UUID(most, least);
            most = buf.readLong();
            least = buf.readLong();
            this.tileId = new UUID(most, least);
        }

        public void toBytes(ByteBuf buf) {
            if (this.networkId == null) {
                this.networkId = DataHelper.INVALID;
            }
            if (this.tileId == null) {
                this.tileId = DataHelper.INVALID;
            }
            long most = this.networkId.getMostSignificantBits();
            long least = this.networkId.getLeastSignificantBits();
            buf.writeLong(most);
            buf.writeLong(least);
            most = this.tileId.getMostSignificantBits();
            least = this.tileId.getLeastSignificantBits();
            buf.writeLong(most);
            buf.writeLong(least);
        }

        public static class Handler
        implements Handlers.ServerHandler<ToggleBrazier> {
            @Override
            public void processMessage(ToggleBrazier message, MessageContext ctx) {
                ImmanenceTileEntity tile;
                if (message.networkId.equals(DataHelper.INVALID) || message.tileId.equals(DataHelper.INVALID)) {
                    return;
                }
                ServerNetwork network = DataHelper.getServerNetwork(message.networkId);
                if (network != null && (tile = network.getImmanenceTile(message.tileId)) instanceof RadiantChestTileEntity) {
                    ((RadiantChestTileEntity)tile).toggleRoutingType();
                    tile.func_70296_d();
                    tile.defaultServerSideUpdate();
                }
            }
        }
    }

    public static class SyncChestDisplay
    extends Messages.TileMessage {
        private ItemStack stack;
        private EnumFacing facing;

        public SyncChestDisplay() {
        }

        public SyncChestDisplay(BlockPos pos, int dimension, ItemStack stack, EnumFacing facing) {
            super(pos, dimension);
            this.stack = stack;
            this.facing = facing;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.facing = EnumFacing.func_82600_a((int)buf.readInt());
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
            buf.writeInt(this.facing.ordinal());
        }

        public static class Handler
        implements Handlers.TileHandlerClient<SyncChestDisplay, RadiantChestTileEntity> {
            @Override
            @SideOnly(value=Side.CLIENT)
            public void processMessage(SyncChestDisplay message, MessageContext ctx, RadiantChestTileEntity tile) {
                if (message.stack.func_190926_b()) {
                    ArcaneArchives.logger.debug("Incoming packet for tile entity in " + tile.dimension + " at " + tile.func_174877_v().toString() + " had an empty itemstack for display.");
                }
                tile.setDisplay(message.stack, message.facing);
            }
        }
    }

    public static class SyncChestName
    extends Messages.TileMessage {
        private String chestName;

        public SyncChestName() {
        }

        public SyncChestName(BlockPos pos, int dimension, String chestName) {
            super(pos, dimension);
            this.chestName = chestName;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.chestName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.chestName);
        }

        public static class Handler
        implements Handlers.TileHandlerClient<SyncChestName, RadiantChestTileEntity> {
            @Override
            @SideOnly(value=Side.CLIENT)
            public void processMessage(SyncChestName message, MessageContext ctx, RadiantChestTileEntity tile) {
                if (message.chestName.isEmpty()) {
                    ArcaneArchives.logger.debug("Incoming packet for tile entity in " + tile.dimension + " at " + tile.func_174877_v().toString() + " had an empty chest name.");
                    tile.unsetChestName();
                } else {
                    tile.setChestName(message.chestName);
                }
            }
        }
    }

    public static class UnsetItem
    extends Messages.TileMessage {
        public UnsetItem() {
        }

        public UnsetItem(BlockPos pos, int dimension) {
            super(pos, dimension);
        }

        public static class Handler
        implements Handlers.TileHandlerServer<UnsetItem, RadiantChestTileEntity> {
            @Override
            public void processMessage(UnsetItem message, MessageContext ctx, RadiantChestTileEntity tile) {
                tile.unsetDisplayStack();
                SyncChestDisplay packet = new SyncChestDisplay(tile.func_174877_v(), tile.dimension, tile.getDisplayStack(), tile.getDisplayFacing());
                Networking.sendToAllTracking((IMessage)packet, tile);
            }
        }
    }

    public static class SetItemAndFacing
    extends Messages.TileMessage {
        private ItemStack stack;
        private EnumFacing facing;

        public SetItemAndFacing() {
        }

        public SetItemAndFacing(BlockPos pos, int dimension, ItemStack stack, EnumFacing facing) {
            super(pos, dimension);
            this.stack = stack;
            this.facing = facing;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            this.facing = EnumFacing.func_82600_a((int)buf.readInt());
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
            buf.writeInt(this.facing.ordinal());
        }

        public static class Handler
        implements Handlers.TileHandlerServer<SetItemAndFacing, RadiantChestTileEntity> {
            @Override
            public void processMessage(SetItemAndFacing message, MessageContext ctx, RadiantChestTileEntity tile) {
                if (message.stack.func_190926_b()) {
                    ArcaneArchives.logger.debug("Incoming packet for tile entity in " + tile.dimension + " at " + tile.func_174877_v().toString() + " had an empty itemstack for display.");
                }
                tile.setDisplay(message.stack, message.facing);
                SyncChestDisplay packet = new SyncChestDisplay(tile.func_174877_v(), tile.dimension, tile.getDisplayStack(), tile.getDisplayFacing());
                Networking.sendToAllTracking((IMessage)packet, tile);
            }
        }
    }

    public static class UnsetName
    extends Messages.TileMessage {
        public UnsetName() {
        }

        public UnsetName(BlockPos pos, int dimensionID) {
            super(pos, dimensionID);
        }

        public static class Handler
        implements Handlers.TileHandlerServer<UnsetName, RadiantChestTileEntity> {
            @Override
            public void processMessage(UnsetName message, MessageContext ctx, RadiantChestTileEntity tile) {
                tile.unsetChestName();
                SyncChestName packet = new SyncChestName(tile.func_174877_v(), tile.dimension, tile.getChestName());
                Networking.sendToAllTracking((IMessage)packet, tile);
            }
        }
    }

    public static class SetName
    extends Messages.TileMessage {
        private String name;

        public SetName() {
        }

        public SetName(BlockPos pos, String name, int dimensionID) {
            super(pos, dimensionID);
            this.name = name == null ? "" : name;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        }

        public static class Handler
        implements Handlers.TileHandlerServer<SetName, RadiantChestTileEntity> {
            @Override
            public void processMessage(SetName message, MessageContext ctx, RadiantChestTileEntity tile) {
                if (message.name.isEmpty()) {
                    ArcaneArchives.logger.debug("Incoming packet for tile entity in " + tile.dimension + " at " + tile.func_174877_v().toString() + " had an empty name.");
                }
                tile.setChestName(message.name);
                SyncChestName packet = new SyncChestName(tile.func_174877_v(), tile.dimension, tile.getChestName());
                Networking.sendToAllTracking((IMessage)packet, tile);
            }
        }
    }
}

