/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.network;

import com.aranaira.arcanearchives.network.Handlers;
import com.aranaira.arcanearchives.network.Messages;
import com.aranaira.arcanearchives.tileentities.BrazierTileEntity;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketBrazier {

    public static class DecrementRadius
    extends Messages.EmptyTileMessageServer<DecrementRadius, BrazierTileEntity> {
        public DecrementRadius(UUID tileId) {
            super(tileId);
        }

        public DecrementRadius() {
        }

        @Override
        public void processMessage(DecrementRadius message, MessageContext ctx, BrazierTileEntity tile) {
            tile.reduceRadius();
            tile.func_70296_d();
            tile.defaultServerSideUpdate();
        }
    }

    public static class IncrementRadius
    extends Messages.EmptyTileMessageServer<IncrementRadius, BrazierTileEntity> {
        public IncrementRadius(UUID tileId) {
            super(tileId);
        }

        public IncrementRadius() {
        }

        @Override
        public void processMessage(IncrementRadius message, MessageContext ctx, BrazierTileEntity tile) {
            tile.increaseRadius();
            tile.func_70296_d();
            tile.defaultServerSideUpdate();
        }
    }

    public static class SetSubnetworkMode
    extends Messages.TileMessage {
        private boolean mode;

        public SetSubnetworkMode() {
        }

        public SetSubnetworkMode(boolean mode, UUID tileId) {
            super(tileId);
            this.mode = mode;
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.mode = buf.readBoolean();
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            buf.writeBoolean(this.mode);
        }

        public static class Handler
        implements Handlers.TileHandlerServer<SetSubnetworkMode, BrazierTileEntity> {
            @Override
            public void processMessage(SetSubnetworkMode message, MessageContext ctx, BrazierTileEntity tile) {
                tile.setNetworkMode(message.mode);
                tile.func_70296_d();
                tile.defaultServerSideUpdate();
            }
        }
    }

    public static class SetRadius
    extends Messages.TileMessage {
        private int radius;

        public SetRadius(int radius, UUID tileId) {
            super(tileId);
            this.radius = radius;
        }

        public SetRadius() {
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            super.fromBytes(buf);
            this.radius = buf.readInt();
        }

        @Override
        public void toBytes(ByteBuf buf) {
            super.toBytes(buf);
            buf.writeInt(this.radius);
        }

        public static class Handler
        implements Handlers.TileHandlerServer<SetRadius, BrazierTileEntity> {
            @Override
            public void processMessage(SetRadius message, MessageContext ctx, BrazierTileEntity tile) {
                tile.setRadius(message.radius);
                tile.func_70296_d();
                tile.defaultServerSideUpdate();
            }
        }
    }
}

