/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.network;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.HiveNetwork;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.network.Messages;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.lists.ITileList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Handlers {

    public static abstract class ConfigServerHandler<T extends Messages.ConfigPacket<?>>
    implements ServerHandler<T> {
        @Override
        public void processMessage(T message, MessageContext ctx) {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server == null) {
                ArcaneArchives.logger.error("Server was null when processing sync packet");
                return;
            }
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ServerNetwork network = DataHelper.getServerNetwork(player.func_110124_au());
            if (network == null) {
                ArcaneArchives.logger.error("Network was null when processing sync packet for " + player.func_110124_au());
                return;
            }
            this.configValueChanged(network, message, ctx);
        }

        public abstract void configValueChanged(ServerNetwork var1, T var2, MessageContext var3);
    }

    public static interface TileHandlerClient<T extends Messages.TileMessage, V extends ImmanenceTileEntity>
    extends ClientHandler<T> {
        @Override
        @SideOnly(value=Side.CLIENT)
        default public void processMessage(T message, MessageContext ctx) {
            V tileEntity = this.getTile(message, ctx);
            if (tileEntity == null) {
                ArcaneArchives.logger.error("Unable to resolve tile reference for message of type " + message.getClass().getSimpleName() + " targetting " + ((Messages.TileMessage)message).getPos() + " in dimension " + ((Messages.TileMessage)message).getDimension() + ". If block exists, you may need to break and re-place it. Halting execution.", (Throwable)new NullPointerException());
                return;
            }
            this.processMessage(message, ctx, tileEntity);
        }

        @Nullable
        @SideOnly(value=Side.CLIENT)
        default public V getTile(T message, MessageContext ctx) {
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            BlockPos pos = ((Messages.TileMessage)message).getPos();
            int dimension = ((Messages.TileMessage)message).getDimension();
            if (((Messages.TileMessage)message).getPos() == null || dimension == -9999) {
                return null;
            }
            if (world.field_73011_w.getDimension() != dimension) {
                return null;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te == null) {
                return null;
            }
            try {
                return (V)((Object)((ImmanenceTileEntity)te));
            }
            catch (ClassCastException exception) {
                ArcaneArchives.logger.error("Attempted to cast to an invalid tile entity: " + te.getClass(), (Throwable)new IllegalArgumentException());
                return null;
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void processMessage(T var1, MessageContext var2, @Nonnull V var3);
    }

    public static interface ClientHandler<T extends IMessage>
    extends BaseHandler<T> {
        default public IMessage onMessage(T message, MessageContext ctx) {
            ArcaneArchives.proxy.scheduleTask(() -> this.processMessage(message, ctx), Side.CLIENT);
            return null;
        }
    }

    public static interface TileHandlerServer<T extends Messages.TileMessage, V extends ImmanenceTileEntity>
    extends ServerHandler<T> {
        @Override
        default public void processMessage(T message, MessageContext ctx) {
            V tile = this.getTile(message, ctx);
            if (tile == null) {
                ArcaneArchives.logger.error("Unable to resolve tile reference for message of type " + message.getClass().getSimpleName() + " targetting " + ((Messages.TileMessage)message).getPos() + " in dimension " + ((Messages.TileMessage)message).getDimension() + ". If block exists, you may need to break and re-place it. Halting execution.", (Throwable)new NullPointerException());
                return;
            }
            this.processMessage(message, ctx, tile);
        }

        @Nullable
        default public V getTile(T message, MessageContext ctx) {
            ITileList tiles;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player == null) {
                return null;
            }
            UUID networkId = player.func_110124_au();
            ServerNetwork network = DataHelper.getServerNetwork(networkId);
            if (network == null) {
                return null;
            }
            if (network.isHiveMember()) {
                HiveNetwork hive = network.getHiveNetwork();
                if (hive == null) {
                    return null;
                }
                tiles = hive.getTiles();
            } else {
                tiles = network.getTiles();
            }
            IteRef ref = ((Messages.TileMessage)message).getTileId() != null ? tiles.getReference(((Messages.TileMessage)message).getTileId()) : tiles.getReference(((Messages.TileMessage)message).getPos(), ((Messages.TileMessage)message).getDimension());
            if (ref == null) {
                return null;
            }
            try {
                return (V)((Object)ref.getTile());
            }
            catch (ClassCastException exception) {
                ArcaneArchives.logger.error("Attempted to cast to an invalid tile entity: " + ((Object)((Object)ref.getTile())).getClass());
                return null;
            }
        }

        public void processMessage(T var1, MessageContext var2, @Nonnull V var3);
    }

    public static interface ServerHandler<T extends IMessage>
    extends BaseHandler<T> {
        default public IMessage onMessage(T message, MessageContext ctx) {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }
    }

    public static interface BaseHandler<T extends IMessage>
    extends IMessageHandler<T, IMessage> {
        public void processMessage(T var1, MessageContext var2);
    }
}

