/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.mixins;

import com.aranaira.arcanearchives.client.gui.GUIGemCuttersTable;
import com.aranaira.arcanearchives.client.gui.GUIGemSocket;
import com.aranaira.arcanearchives.client.gui.GUIManifest;
import com.aranaira.arcanearchives.client.gui.GUIRadiantChest;
import com.aranaira.arcanearchives.client.gui.GUIUpgrades;
import com.aranaira.arcanearchives.client.render.LineHandler;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.util.ColorUtils;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiContainer.class})
public class MixinGuiContainer {
    @SideOnly(value=Side.CLIENT)
    private static List<Class<? extends GuiContainer>> CONTAINER_IGNORE_LIST = Arrays.asList(GUIManifest.class, GUIGemCuttersTable.class, GUIUpgrades.class, GUIRadiantChest.class, GUIGemSocket.class);

    private static void drawSlot(GuiContainer container, Slot slot) {
        if (ConfigHandler.nonModTrackingConfig.DisableMixinHighlight || ConfigHandler.nonModTrackingConfig.getContainerClasses().contains(container.getClass())) {
            return;
        }
        if (CONTAINER_IGNORE_LIST.contains(container.getClass())) {
            return;
        }
        ItemStack stack = slot.func_75211_c();
        if (!stack.func_190926_b() && ManifestTrackingUtils.matches(stack)) {
            GlStateManager.func_179097_i();
            long worldTime = container.field_146297_k.field_71439_g.field_70170_p.func_72820_D();
            ColorUtils.Color c = ColorUtils.getColorFromTime(worldTime);
            GuiContainer.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)c.toInteger());
            GlStateManager.func_179126_j();
        }
    }

    @Inject(method={"drawSlot"}, at={@At(value="HEAD")})
    @SideOnly(value=Side.CLIENT)
    private void onDrawSlot(Slot slot, CallbackInfo callbackInfo) {
        MixinGuiContainer.drawSlot((GuiContainer)this, slot);
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="RETURN")})
    @SideOnly(value=Side.CLIENT)
    private void onGuiClosed(CallbackInfo callbackInfo) {
        Minecraft _mc = ((GuiContainer)this).field_146297_k;
        if (_mc != null && _mc.field_71439_g != null) {
            LineHandler.checkClear(_mc.field_71439_g.field_71093_bK);
        }
    }
}

