/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.pendeloque;

import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ParchtearItem
extends ArcaneGemItem {
    public static final String NAME = "parchtear";
    public static final int CUBOID_RADIUS = 1;

    public ParchtearItem() {
        super(NAME, ArcaneGemItem.GemCut.PENDELOQUE, ArcaneGemItem.GemColor.BLACK, 8000, 27000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.parchtear", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.parchtear", (Object[])new Object[0]));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        GemUtil.AvailableGemsHandler.HandedGemsHandler handler;
        if (!world.field_72995_K && ((GemUtil.AvailableGemsHandler)(handler = GemUtil.getHeldGem(player, hand))).getHeld() != null && GemUtil.getCharge(((GemUtil.AvailableGemsHandler)handler).getHeld()) > 0) {
            ArrayList<Object> positions = new ArrayList<BlockPos>();
            Vec3d start = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
            Vec3d dir = player.func_70040_Z();
            Vec3d rayTarget = new Vec3d(start.field_72450_a + dir.field_72450_a * 40.0, start.field_72448_b + dir.field_72448_b * 40.0, start.field_72449_c + dir.field_72449_c * 40.0);
            RayTraceResult ray = world.func_147447_a(start, rayTarget, true, false, false);
            if (ray != null) {
                BlockPos root = ray.func_178782_a();
                if (!player.func_70093_af()) {
                    positions = this.getPositionsInCuboidRadius(root, 1);
                } else {
                    positions.add(root);
                }
                int chargeCost = 0;
                for (BlockPos blockPos : positions) {
                    Block block = world.func_180495_p(blockPos).func_177230_c();
                    if (!(block instanceof IFluidBlock) && !(block instanceof BlockStaticLiquid) && !(block instanceof BlockDynamicLiquid)) continue;
                    world.func_175656_a(blockPos, BlockRegistry.FAKE_AIR.func_176223_P());
                    ++chargeCost;
                }
                GemUtil.consumeCharge(((GemUtil.AvailableGemsHandler)handler).getHeld(), chargeCost);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private ArrayList<BlockPos> getPositionsInCuboidRadius(BlockPos root, int radius) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    positions.add(root.func_177982_a(i, j, k));
                }
            }
        }
        return positions;
    }
}

