/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.asscher;

import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.util.ItemUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SalvegleamItem
extends ArcaneGemItem {
    public static final String NAME = "salvegleam";
    public static final int PULSE_TICKS = 20;

    public SalvegleamItem() {
        super(NAME, ArcaneGemItem.GemCut.ASSCHER, ArcaneGemItem.GemColor.PINK, 30, 150);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.salvegleam", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.salvegleam", (Object[])new Object[0]));
    }

    @Override
    public boolean hasToggleMode() {
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            // empty if block
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static boolean canDoHealingPulse(GemUtil.GemStack stack) {
        boolean thresholdPassed = false;
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack.getStack());
        if (!nbt.func_74764_b("pulse")) {
            thresholdPassed = true;
            nbt.func_74768_a("pulse", 20);
        } else {
            int timer = nbt.func_74762_e("pulse");
            if (--timer == 0) {
                thresholdPassed = true;
                nbt.func_74768_a("pulse", 20);
            } else {
                nbt.func_74768_a("pulse", timer);
            }
        }
        return thresholdPassed;
    }
}

