/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.asscher;

import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.tmtravlr.potioncore.PotionCoreEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CleansegleamItem
extends ArcaneGemItem {
    public static final String NAME = "cleansegleam";

    public CleansegleamItem() {
        super(NAME, ArcaneGemItem.GemCut.ASSCHER, ArcaneGemItem.GemColor.BLUE, 30, 150);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.cleansegleam", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.cleansegleam", (Object[])new Object[0]));
    }

    @Override
    public boolean hasToggleMode() {
        return false;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        GemUtil.AvailableGemsHandler.HandedGemsHandler handler;
        if (!world.field_72995_K && ((GemUtil.AvailableGemsHandler)(handler = GemUtil.getHeldGem(player, hand))).getHeld() != null) {
            if (GemUtil.getCharge(((GemUtil.AvailableGemsHandler)handler).getHeld()) == 0) {
                IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                for (int i = 0; i < playerInventory.getSlots(); ++i) {
                    ItemStack result;
                    ItemStack bucket = ItemStack.field_190927_a;
                    ItemStack stackInSlot = playerInventory.getStackInSlot(i);
                    if (stackInSlot.func_77973_b() == Items.field_151117_aB) {
                        this.informPlayerOfItemConsumption(player, this, stackInSlot, 1);
                        playerInventory.extractItem(i, 1, false);
                        if (bucket.func_190926_b()) {
                            bucket = new ItemStack(Items.field_151133_ar);
                        } else {
                            bucket.func_190920_e(bucket.func_190916_E() + 1);
                        }
                    }
                    if ((result = ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)bucket, (boolean)false)).func_190926_b()) continue;
                    Block.func_180635_a((World)world, (BlockPos)player.func_180425_c(), (ItemStack)result);
                }
            } else {
                int chargeCost = this.removeEffects((EntityLivingBase)player, false);
                if (player.func_70093_af()) {
                    double boxRadius = 3.5;
                    AxisAlignedBB aabb = new AxisAlignedBB(player.field_70165_t - boxRadius, player.field_70163_u - boxRadius, player.field_70161_v - boxRadius, player.field_70165_t + boxRadius, player.field_70163_u + boxRadius, player.field_70161_v + boxRadius);
                    for (EntityLivingBase entity : player.field_70170_p.func_72872_a(EntityLivingBase.class, aabb)) {
                        chargeCost += this.removeEffects(entity, false);
                    }
                }
                if (chargeCost > 0) {
                    GemUtil.consumeCharge(((GemUtil.AvailableGemsHandler)handler).getHeld(), chargeCost);
                }
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private int removeEffects(EntityLivingBase target, boolean hasMatterUpgrade) {
        ArrayList<Potion> toRemove = new ArrayList<Potion>();
        int cost = 0;
        boolean hasAntidote = false;
        boolean hasPurity = false;
        for (PotionEffect effect : target.func_70651_bq()) {
            if (effect.func_76453_d().equals(MobEffects.field_76438_s.func_76393_a())) {
                toRemove.add(effect.func_188419_a());
            } else if (effect.func_76453_d().equals(MobEffects.field_76431_k.func_76393_a())) {
                toRemove.add(effect.func_188419_a());
            } else if (effect.func_76453_d().equals(MobEffects.field_76436_u.func_76393_a())) {
                toRemove.add(effect.func_188419_a());
            } else if (hasMatterUpgrade && effect.func_188419_a().func_76398_f()) {
                toRemove.add(effect.func_188419_a());
                cost = 3;
            }
            if (effect.func_76453_d().equals("effect.antidote")) {
                hasAntidote = true;
            }
            if (!effect.func_76453_d().equals("effect.purity")) continue;
            hasPurity = true;
        }
        if (Loader.isModLoaded((String)"potioncore")) {
            if (!hasAntidote) {
                Potion antidote = (Potion)PotionCoreEffects.POTIONS.get("antidote");
                target.func_70690_d(new PotionEffect(antidote, 1200));
                if (cost == 0) {
                    cost = 1;
                }
            }
            if (!hasPurity && hasMatterUpgrade) {
                Potion purity = (Potion)PotionCoreEffects.POTIONS.get("purity");
                target.func_70690_d(new PotionEffect(purity, 1200));
                if (cost == 0) {
                    cost = 1;
                }
            }
        }
        if (toRemove.size() > 0 && cost == 0) {
            cost = 1;
        }
        for (Potion remove : toRemove) {
            target.func_184589_d(remove);
        }
        return cost;
    }

    @Optional.Method(modid="potioncore")
    private void applyPotionCoreBuffs() {
    }
}

