/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items.gems.asscher;

import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.util.ItemUtils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AgegleamItem
extends ArcaneGemItem {
    public static final String NAME = "agegleam";
    public static final int CHARGE_TICKS = 3600;

    public AgegleamItem() {
        super(NAME, ArcaneGemItem.GemCut.ASSCHER, ArcaneGemItem.GemColor.GREEN, 30, 150);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.gemcharge", (Object[])new Object[0]) + ": " + this.getTooltipData(stack));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.agegleam", (Object[])new Object[0]));
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.gem.recharge.agegleam", (Object[])new Object[0]));
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        GemUtil.AvailableGemsHandler.HandedGemsHandler handler;
        if (!world.field_72995_K && ((GemUtil.AvailableGemsHandler)(handler = GemUtil.getHeldGem(player, hand))).getHeld() != null) {
            int chargeCost = 0;
            double boxRadius = 3.5;
            AxisAlignedBB aabb = new AxisAlignedBB(player.field_70165_t - boxRadius, player.field_70163_u - boxRadius, player.field_70161_v - boxRadius, player.field_70165_t + boxRadius, player.field_70163_u + boxRadius, player.field_70161_v + boxRadius);
            for (EntityAgeable entity : player.field_70170_p.func_72872_a(EntityAgeable.class, aabb)) {
                if (!entity.func_70631_g_()) continue;
                entity.func_70873_a(entity.func_70874_b() + 8000);
                ++chargeCost;
            }
            if (chargeCost > 0) {
                GemUtil.consumeCharge(((GemUtil.AvailableGemsHandler)handler).getHeld(), chargeCost);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static boolean processRechargeTime(GemUtil.GemStack stack) {
        boolean thresholdPassed = false;
        NBTTagCompound nbt = ItemUtils.getOrCreateTagCompound(stack.getStack());
        if (!nbt.func_74764_b("recharge")) {
            nbt.func_74768_a("recharge", 3600);
        } else {
            int timer = nbt.func_74762_e("recharge");
            if (--timer == 0) {
                GemUtil.restoreCharge(stack, 1);
                nbt.func_74768_a("recharge", 3600);
            } else {
                nbt.func_74768_a("recharge", timer);
            }
        }
        return thresholdPassed;
    }
}

