/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.HiveSaveData;
import com.aranaira.arcanearchives.items.templates.LetterTemplate;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WritOfExpulsionItem
extends LetterTemplate {
    public static final String NAME = "writ_expulsion";

    public WritOfExpulsionItem() {
        super(NAME);
    }

    @Override
    public ItemStack letterTriggered(ItemStack stack, World world, EntityLivingBase entity) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("creator_name")) {
            entity.func_145747_a((ITextComponent)new TextComponentString("Invalid letter! Oops?"));
            return stack;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!tag.func_74764_b("expel_name")) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.expel_unnamed", new Object[0]), true);
            return stack;
        }
        UUID network = tag.func_186857_a("creator");
        UUID playerId = entity.func_110124_au();
        UUID expelId = tag.func_186857_a("expel");
        if (!network.equals(playerId)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.expel_no_permission", new Object[0]), true);
            return stack;
        }
        HiveSaveData saveData = DataHelper.getHiveData();
        HiveSaveData.Hive hive = saveData.getHiveByMember(expelId);
        if (!hive.owner.equals(playerId)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.expel_no_permission", new Object[0]), true);
            return stack;
        }
        if (saveData.removeMember(hive, expelId)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.expelled", new Object[]{tag.func_74779_i("expel_name")}), true);
            saveData.alertMembers(world, hive, expelId, false);
            EntityPlayer expelled = world.func_152378_a(expelId);
            if (expelled != null) {
                expelled.func_145747_a((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.were_expelled", new Object[0]));
            }
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.expel_failed", new Object[]{tag.func_74779_i("expel_name")}), true);
            return stack;
        }
        saveData.func_76185_a();
        world.func_175693_T().func_75744_a();
        stack.func_190918_g(1);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("expel_name")) {
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.writ_expulsion.named", (Object[])new Object[]{tag.func_74779_i("expel_name")}));
        } else {
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.writ_expulsion", (Object[])new Object[0]));
        }
    }
}

