/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.blocks.MonitoringCrystal;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.items.templates.IItemScepter;
import com.aranaira.arcanearchives.items.templates.ItemTemplate;
import com.aranaira.arcanearchives.tileentities.MonitoringCrystalTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantCraftingTableTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantResonatorTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTankTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class ScepterRevelationItem
extends ItemTemplate
implements IItemScepter {
    public static final String NAME = "scepter_revelation";

    public ScepterRevelationItem() {
        super(NAME);
        this.func_77625_d(1);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return EnumActionResult.SUCCESS;
        }
        if (world.func_175623_d(pos)) {
            return EnumActionResult.SUCCESS;
        }
        player.func_184609_a(hand);
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        Style def = new Style().func_150238_a(TextFormatting.GOLD);
        Style error = new Style().func_150238_a(TextFormatting.DARK_RED).func_150227_a(Boolean.valueOf(true));
        if (block == BlockRegistry.RADIANT_CHEST) {
            RadiantChestTileEntity te = WorldUtil.getTileEntity(RadiantChestTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.missing_te", new Object[0]).func_150255_a(error));
                return EnumActionResult.SUCCESS;
            }
            if (te.getChestName().isEmpty()) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_chest.unnamed", new Object[0]).func_150255_a(def));
            } else {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_chest.name", new Object[]{te.getChestName()}).func_150255_a(def));
            }
            player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_chest.slots", new Object[]{te.countEmptySlots()}).func_150255_a(def));
        } else if (block == BlockRegistry.RADIANT_CRAFTING_TABLE) {
            RadiantCraftingTableTileEntity te = WorldUtil.getTileEntity(RadiantCraftingTableTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.missing_te", new Object[0]).func_150255_a(error));
                return EnumActionResult.SUCCESS;
            }
            ItemStackHandler inventory = te.getInventory();
            boolean empty = true;
            ArrayList<TextComponentTranslation> names = new ArrayList<TextComponentTranslation>();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                empty = false;
                names.add(new TextComponentTranslation(stack.func_77977_a() + ".name", new Object[0]));
            }
            if (empty) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_crafting.empty", new Object[0]).func_150255_a(def));
            } else {
                TextComponentString base = new TextComponentString("");
                for (int i = 0; i < names.size(); ++i) {
                    base.func_150257_a((ITextComponent)names.get(i));
                    if (i == names.size() - 1) continue;
                    base.func_150258_a(", ");
                }
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_crafting.contains", new Object[]{base}).func_150255_a(def));
            }
        } else if (block == BlockRegistry.RADIANT_TANK) {
            RadiantTankTileEntity te = WorldUtil.getTileEntity(RadiantTankTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.missing_te", new Object[0]).func_150255_a(error));
                return EnumActionResult.SUCCESS;
            }
            IFluidHandler cap = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            FluidStack fluid = te.getInventory().getFluid();
            int amount = te.getInventory().getFluidAmount();
            int maxCount = te.getCapacity();
            if (fluid == null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_tank.empty", new Object[0]).func_150255_a(def));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("arcanearchives.data.scepter.radiant_tank.item", new Object[]{new TextComponentTranslation(fluid.getLocalizedName(), new Object[0]).func_150255_a(def)}));
            }
            player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_tank.count", new Object[]{amount, maxCount}).func_150255_a(def));
        } else if (block == BlockRegistry.RADIANT_TROVE) {
            RadiantTroveTileEntity te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.missing_te", new Object[0]).func_150255_a(error));
                return EnumActionResult.SUCCESS;
            }
            RadiantTroveTileEntity.TroveItemHandler inventory = te.getInventory();
            ItemStack reference = inventory.getItemCurrent();
            int count = inventory.getCount();
            int storageUpgrades = inventory.getTotalUpgradesCount().x;
            int optionalUpgrades = inventory.getTotalUpgradesCount().y;
            int maxCount = inventory.getMaxCount();
            if (reference.func_190926_b()) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_trove.empty", new Object[0]).func_150255_a(def));
            } else {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_trove.item", new Object[]{new TextComponentTranslation(reference.func_77977_a() + ".name", new Object[0])}).func_150255_a(def));
            }
            player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_trove.count", new Object[]{count, maxCount}).func_150255_a(def));
            if (storageUpgrades + optionalUpgrades > 0) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_trove.upgrades", new Object[]{"" + storageUpgrades, "" + optionalUpgrades}).func_150255_a(def));
            }
        } else if (block == BlockRegistry.RADIANT_RESONATOR) {
            RadiantResonatorTileEntity te = WorldUtil.getTileEntity(RadiantResonatorTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.missing_te", new Object[0]).func_150255_a(error));
                return EnumActionResult.SUCCESS;
            }
            player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.radiant_resonator.progress", new Object[]{te.getPercentageComplete()}).func_150255_a(def));
            RadiantResonatorTileEntity.TickResult res = te.canTick();
            player.func_145747_a((ITextComponent)new TextComponentTranslation("arcanearchives.data.scepter.radiant_resonator.status", new Object[]{new TextComponentTranslation(res.getKey(), new Object[0]).func_150255_a(new Style().func_150238_a(res.getFormat()))}));
        } else if (block == BlockRegistry.MONITORING_CRYSTAL) {
            MonitoringCrystalTileEntity te = WorldUtil.getTileEntity(MonitoringCrystalTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.missing_te", new Object[0]).func_150255_a(error));
                return EnumActionResult.SUCCESS;
            }
            EnumFacing te_facing = ((EnumFacing)state.func_177229_b((IProperty)MonitoringCrystal.FACING)).func_176734_d();
            player.func_145747_a(new TextComponentTranslation("arcanearchives.data.scepter.monitoring_crystal.facing", new Object[]{te_facing.func_176610_l()}).func_150255_a(def));
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.scepter_revelation", (Object[])new Object[0]));
    }
}

