/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.items.templates.ItemTemplate;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantCraftingTableTileEntity;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RawQuartzItem
extends ItemTemplate {
    public static final String NAME = "raw_quartz";

    public RawQuartzItem() {
        super(NAME);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.raw_quartz", (Object[])new Object[0]));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        ItemStack itemstack = player.func_184586_b(hand);
        IBlockState mainState = world.func_180495_p(pos);
        if (mainState.func_177230_c() instanceof BlockChest) {
            if (world.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            TileEntity te = world.func_175625_s(pos);
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack slot = handler.extractItem(i, 64, false);
                if (slot.func_190926_b()) continue;
                stacks.add(slot);
            }
            world.func_175656_a(pos, BlockRegistry.RADIANT_CHEST.func_176223_P());
            RadiantChestTileEntity ite = WorldUtil.getTileEntity(RadiantChestTileEntity.class, (IBlockAccess)world, pos);
            ArrayList<ItemStack> leftover = new ArrayList<ItemStack>();
            if (ite != null) {
                ite.setNetworkId(player.func_110124_au());
                handler = (IItemHandler)ite.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                for (ItemStack stack : stacks) {
                    ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                    if (result.func_190926_b()) continue;
                    leftover.add(result);
                }
            } else {
                for (ItemStack stack : stacks) {
                    Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)stack);
                }
                return EnumActionResult.SUCCESS;
            }
            if (!leftover.isEmpty()) {
                for (ItemStack stack : stacks) {
                    Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)stack);
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        if (mainState.func_177230_c() instanceof BlockWorkbench) {
            IBlockState iblockstate = BlockRegistry.RADIANT_CRAFTING_TABLE.func_176223_P();
            world.func_175656_a(pos, iblockstate);
            itemstack.func_190918_g(1);
            RadiantCraftingTableTileEntity te = WorldUtil.getTileEntity(RadiantCraftingTableTileEntity.class, (IBlockAccess)world, pos);
            if (te != null) {
                te.setNetworkId(player.func_110124_au());
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

