/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.HiveSaveData;
import com.aranaira.arcanearchives.items.templates.LetterTemplate;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LetterOfInvitationItem
extends LetterTemplate {
    public static final String NAME = "letter_invitation";

    public LetterOfInvitationItem() {
        super(NAME);
    }

    @Override
    public ItemStack letterTriggered(ItemStack stack, World world, EntityLivingBase entity) {
        HiveSaveData.Hive hive;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("creator_name")) {
            entity.func_145747_a((ITextComponent)new TextComponentString("Invalid letter! Oops?"));
            return stack;
        }
        UUID network = tag.func_186857_a("creator");
        UUID playerId = entity.func_110124_au();
        EntityPlayer player = (EntityPlayer)entity;
        if (network.equals(playerId)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.yours", new Object[0]), true);
            return stack;
        }
        HiveSaveData saveData = DataHelper.getHiveData();
        if (!saveData.addMember(hive = saveData.getHiveByOwner(network), playerId)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.failed", new Object[0]), true);
            return stack;
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation("arcanearchives.network.hive.joined", new Object[]{tag.func_74779_i("creator_name")}), true);
        saveData.alertMembers(world, hive, player.func_110124_au(), true);
        saveData.func_76185_a();
        world.func_175693_T().func_75744_a();
        stack.func_190918_g(1);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null || !tag.func_74764_b("creator_name")) {
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.letter_invitation", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.letter_invitation.named", (Object[])new Object[]{tag.func_74779_i("creator_name")}));
        }
    }
}

