/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.items;

import com.aranaira.arcanearchives.blocks.RadiantChest;
import com.aranaira.arcanearchives.blocks.RadiantTank;
import com.aranaira.arcanearchives.blocks.RadiantTrove;
import com.aranaira.arcanearchives.blocks.templates.BlockTemplate;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.inventory.handlers.OptionalUpgradesHandler;
import com.aranaira.arcanearchives.inventory.handlers.SizeUpgradeItemHandler;
import com.aranaira.arcanearchives.items.templates.ItemTemplate;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTankTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.enums.UpgradeType;
import com.aranaira.arcanearchives.types.lists.TileList;
import com.aranaira.arcanearchives.util.UploadUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.io.IOException;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="arcanearchives")
public class DebugOrbItem
extends ItemTemplate {
    public static final String NAME = "debugorb";

    public DebugOrbItem() {
        super(NAME);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.item.debugorb", (Object[])new Object[0]));
        tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"arcanearchives.tooltip.creativeonly", (Object[])new Object[0]));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        String url;
        OptionalUpgradesHandler optionals;
        SizeUpgradeItemHandler sizes;
        ImmanenceTileEntity te;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || !(block instanceof BlockTemplate) || !block.hasTileEntity(state)) {
            return EnumActionResult.PASS;
        }
        ImmanenceTileEntity ite = WorldUtil.getTileEntity(ImmanenceTileEntity.class, (IBlockAccess)world, pos);
        if (ite == null) {
            return EnumActionResult.PASS;
        }
        if (player.func_70093_af() && block instanceof RadiantTrove && ite instanceof RadiantTroveTileEntity) {
            RadiantTroveTileEntity rte = (RadiantTroveTileEntity)ite;
            RadiantTroveTileEntity.TroveItemHandler handler = rte.getInventory();
            if (handler.getItem().func_190926_b()) {
                handler.setReference(new ItemStack(Items.field_151126_ay));
                handler.setCount(handler.getMaxCount());
                player.func_146105_b(new TextComponentString("Filled your empty trove!").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD).func_150227_a(Boolean.valueOf(true))), true);
                return EnumActionResult.SUCCESS;
            }
            handler.setReference(ItemStack.field_190927_a);
            handler.setCount(0);
            player.func_146105_b(new TextComponentString("Hope you didn't need what was in there!").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED).func_150227_a(Boolean.valueOf(true))), true);
            return EnumActionResult.SUCCESS;
        }
        if (player.func_70093_af()) {
            return EnumActionResult.SUCCESS;
        }
        ServerNetwork sNetwork = null;
        if (!world.field_72995_K) {
            sNetwork = DataHelper.getServerNetwork(ite.getNetworkId());
        }
        if (world.field_72995_K) {
            player.func_145747_a(new TextComponentString(" --- BEGINNING DEBUG --- WARNING: MAY CAUSE LAG/SHORT LOCK-UP, DON'T PANIC!").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD).func_150227_a(Boolean.valueOf(true))));
        }
        String debugOutput = "";
        debugOutput = world.field_72995_K ? debugOutput + "---------- CLIENT SIDE REPORT ----------\n" : debugOutput + "---------- SERVER SIDE REPORT ----------\n";
        debugOutput = debugOutput + "Block located at: " + pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p() + "\n";
        if (block instanceof RadiantChest) {
            debugOutput = debugOutput + "- is a Radiant Chest\n";
            te = WorldUtil.getTileEntity(RadiantChestTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                debugOutput = debugOutput + "- has INVALID TILE ENTITY\n";
            } else {
                debugOutput = te.getNetworkId() != null ? debugOutput + "- Part of the network " + te.getNetworkId().toString() + "\n" : debugOutput + "- has INVALID NETWORK ID\n";
                debugOutput = te.getUuid() != null ? debugOutput + "- Has tile id " + te.getUuid().toString() + "\n" : debugOutput + "- has INVALID TILE ID\n";
                debugOutput = ((RadiantChestTileEntity)te).getDisplayStack().func_190926_b() ? debugOutput + "- Has no set display item\n" : debugOutput + "- Has " + ((RadiantChestTileEntity)te).getDisplayStack().toString() + " (" + ((RadiantChestTileEntity)te).getDisplayStack().func_77973_b().getRegistryName() + ") as display item\n";
                debugOutput = debugOutput + "- Has display facing " + ((RadiantChestTileEntity)te).getDisplayFacing().toString() + "\n";
                debugOutput = debugOutput + "- Has brazier routing type " + ((RadiantChestTileEntity)te).getRoutingType().toString() + "\n";
                debugOutput = debugOutput + "- Has chest name '" + ((RadiantChestTileEntity)te).chestName + "'\n";
                debugOutput = debugOutput + "- Contains " + ((RadiantChestTileEntity)te).getOrCalculateReference().size() + " unique items\n";
                if (sNetwork != null) {
                    debugOutput = sNetwork.containsTile(te) ? debugOutput + "- Is contained in network tile list\n" : debugOutput + "- Is NOT contained in network tile list\n";
                    TileList tiles = sNetwork.getTiles();
                    IteRef ref = tiles.getReference(te.getUuid());
                    if (ref == null) {
                        debugOutput = debugOutput + "- Tile List reference is null\n";
                    }
                }
            }
        } else if (block instanceof RadiantTrove) {
            debugOutput = debugOutput + "- is a Radiant Trove\n";
            te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                debugOutput = debugOutput + "- has INVALID TILE ENTITY\n";
            } else {
                debugOutput = te.getNetworkId() != null ? debugOutput + "- Part of the network " + te.getNetworkId().toString() + "\n" : debugOutput + "- has INVALID NETWORK ID\n";
                debugOutput = te.getUuid() != null ? debugOutput + "- Has tile id " + te.getUuid().toString() + "\n" : debugOutput + "- has INVALID TILE ID\n";
                debugOutput = debugOutput + "- last click is " + ((RadiantTroveTileEntity)te).getLastClick() + "\n";
                debugOutput = debugOutput + "- last tick is " + ((RadiantTroveTileEntity)te).getLastTick() + "\n";
                debugOutput = ((RadiantTroveTileEntity)te).getLastUUID() == null ? debugOutput + "- no last UUID\n" : debugOutput + "- last UUID is " + ((RadiantTroveTileEntity)te).getLastUUID().toString() + "\n";
                sizes = ((RadiantTroveTileEntity)te).getSizeUpgradesHandler();
                debugOutput = debugOutput + "- has " + sizes.getUpgradesCount() + " upgrades\n";
                optionals = ((RadiantTroveTileEntity)te).getOptionalUpgradesHandler();
                debugOutput = debugOutput + "- " + (optionals.hasUpgrade(UpgradeType.VOID) ? "has" : "does not have") + " void upgrade\n";
                RadiantTroveTileEntity.TroveItemHandler inventory = ((RadiantTroveTileEntity)te).getInventory();
                debugOutput = debugOutput + "- contains " + inventory.getItem().toString() + " (" + inventory.getItem().func_77973_b().getRegistryName() + ")\n";
                debugOutput = debugOutput + "- has total of " + inventory.getCount() + " items stored\n";
                if (sNetwork != null) {
                    debugOutput = sNetwork.containsTile(te) ? debugOutput + "- Is contained in network tile list\n" : debugOutput + "- Is NOT contained in network tile list\n";
                    TileList tiles = sNetwork.getTiles();
                    IteRef ref = tiles.getReference(te.getUuid());
                    if (ref == null) {
                        debugOutput = debugOutput + "- Tile List reference is null\n";
                    }
                }
            }
        } else if (block instanceof RadiantTank) {
            debugOutput = debugOutput + "- is a Radiant Tank\n";
            te = WorldUtil.getTileEntity(RadiantTankTileEntity.class, (IBlockAccess)world, pos);
            if (te == null) {
                debugOutput = debugOutput + "- has INVALID TILE ENTITY\n";
            } else {
                debugOutput = te.getNetworkId() != null ? debugOutput + "- Part of the network " + te.getNetworkId().toString() + "\n" : debugOutput + "- has INVALID NETWORK ID\n";
                debugOutput = te.getUuid() != null ? debugOutput + "- Has tile id " + te.getUuid().toString() + "\n" : debugOutput + "- has INVALID TILE ID\n";
                sizes = ((RadiantTankTileEntity)te).getSizeUpgradesHandler();
                debugOutput = debugOutput + "- has " + sizes.getUpgradesCount() + " upgrades\n";
                optionals = ((RadiantTankTileEntity)te).getOptionalUpgradesHandler();
                debugOutput = debugOutput + "- " + (optionals.hasUpgrade(UpgradeType.VOID) ? "has" : "does not have") + " void upgrade\n";
                RadiantTankTileEntity.VoidingFluidTank inventory = ((RadiantTankTileEntity)te).getInventory();
                FluidStack contents = inventory.getFluid();
                debugOutput = debugOutput + "- " + (contents == null ? "contains no fluid " : "contains " + contents.getUnlocalizedName()) + "\n";
                if (contents != null) {
                    debugOutput = debugOutput + "- contains " + contents.amount + "mb of fluid\n";
                }
                if (sNetwork != null) {
                    debugOutput = sNetwork.containsTile(te) ? debugOutput + "- Is contained in network tile list\n" : debugOutput + "- Is NOT contained in network tile list\n";
                    TileList tiles = sNetwork.getTiles();
                    IteRef ref = tiles.getReference(te.getUuid());
                    if (ref == null) {
                        debugOutput = debugOutput + "- Tile List reference is null\n";
                    }
                }
            }
        } else {
            return EnumActionResult.PASS;
        }
        String identifier = world.field_72995_K ? "Client" : "Server";
        try {
            url = UploadUtils.uploadToHaste("debug" + identifier, debugOutput);
        }
        catch (IOException e) {
            player.func_145747_a((ITextComponent)new TextComponentString("Unable to upload " + identifier + " debug information to HasteBin."));
            e.printStackTrace();
            return EnumActionResult.SUCCESS;
        }
        player.func_145747_a(DebugOrbItem.getCopyMessage("Successfully uploaded " + identifier + " report to HasteBin: " + url, url));
        return EnumActionResult.SUCCESS;
    }

    public static ITextComponent getCopyMessage(String message, String copyMessage) {
        Style style = new Style();
        ClickEvent click = new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/clipboard " + copyMessage);
        style.func_150241_a(click);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString("Click to copy [\u00a76" + copyMessage + "\u00a7r]"));
        style.func_150209_a(hoverEvent);
        return new TextComponentString(message).func_150255_a(style);
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        if (player.func_184614_ca().func_77973_b() != ItemRegistry.DEBUG_ORB) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(block instanceof BlockTemplate)) {
            return;
        }
        if (block instanceof RadiantChest) {
            event.setUseBlock(Event.Result.DENY);
            event.setUseItem(Event.Result.DENY);
            RadiantChestTileEntity te = WorldUtil.getTileEntity(RadiantChestTileEntity.class, (IBlockAccess)world, pos);
            player.func_145747_a((ITextComponent)new TextComponentString(world.field_72995_K ? "Client-side data:" : "Server-side data:"));
            if (te == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("There's no Radiant Chest tile entity! WTF?"));
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Radiant chest is named: " + te.getChestName()));
            EnumFacing facing = te.getDisplayFacing();
            ItemStack display = te.getDisplayStack();
            if (display.func_190926_b()) {
                player.func_145747_a((ITextComponent)new TextComponentString("Radiant chest has no item stack on display."));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Radiant chest has a display item facing " + facing.toString() + " which is: " + display.toString()));
            }
        }
    }
}

