/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import com.aranaira.arcanearchives.items.IUpgradeItem;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class SizeUpgradeItemHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<NBTTagCompound> {
    protected boolean[] upgrades = new boolean[]{false, false, false};

    public int getSlots() {
        return this.upgrades.length;
    }

    public abstract Item getUpgradeForSlot(int var1);

    public boolean canReduceMultiplierTo(int size) {
        return false;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.func_77973_b() == this.getUpgradeForSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.getSlots()) {
            return stack;
        }
        if (stack.func_77973_b() == this.getUpgradeForSlot(slot) && this.resolveUpgradesUntil(slot)) {
            if (!simulate) {
                this.upgrades[slot] = true;
                this.onContentsChanged();
            }
            if (stack.func_190916_E() > 1) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190918_g(1);
                return copy;
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount != 1) {
            return ItemStack.field_190927_a;
        }
        if (slot >= this.getSlots()) {
            return ItemStack.field_190927_a;
        }
        if (slot == 0 && (this.upgrades[1] || this.upgrades[2]) || slot == 1 && this.upgrades[2]) {
            return ItemStack.field_190927_a;
        }
        if (slot > 0 && !this.canReduceMultiplierTo(this.getUpgradesCount(slot))) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            this.upgrades[slot] = false;
            this.onContentsChanged();
        }
        return new ItemStack(this.getUpgradeForSlot(slot));
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean resolveUpgradesUntil(int slot) {
        if (slot == 0) {
            return true;
        }
        return this.resolveUpgradesIncluding(slot - 1);
    }

    public boolean resolveUpgradesIncluding(int slot) {
        if (slot >= 3) {
            return false;
        }
        for (int i = 0; i <= slot; ++i) {
            if (this.upgrades[i]) continue;
            return false;
        }
        return true;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("0", this.upgrades[0]);
        tag.func_74757_a("1", this.upgrades[1]);
        tag.func_74757_a("2", this.upgrades[2]);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tags) {
        this.upgrades[0] = tags.func_74767_n("0");
        this.upgrades[1] = tags.func_74767_n("1");
        this.upgrades[2] = tags.func_74767_n("2");
    }

    public int getUpgradesCount(int slot) {
        int count = 0;
        for (int i = 0; i <= slot; ++i) {
            count += ((IUpgradeItem)this.getUpgradeForSlot(i)).getUpgradeSize(ItemStack.field_190927_a);
        }
        return count;
    }

    public boolean getIsUpgradePresent(int slot) {
        return !this.getStackInSlot(slot).func_190926_b();
    }

    public boolean hasUpgrade(ItemStack stack) {
        return this.upgrades[((IUpgradeItem)stack.func_77973_b()).getSlotIsUpgradeFor(stack)];
    }

    public boolean hasUpgrade(int slot) {
        return this.hasUpgrade(new ItemStack(this.getUpgradeForSlot(slot)));
    }

    public int getUpgradesCount() {
        int count = 0;
        if (this.resolveUpgradesIncluding(0)) {
            count += ((IUpgradeItem)this.getUpgradeForSlot(0)).getUpgradeSize(ItemStack.field_190927_a);
        }
        if (this.resolveUpgradesIncluding(1)) {
            count += ((IUpgradeItem)this.getUpgradeForSlot(1)).getUpgradeSize(ItemStack.field_190927_a);
        }
        if (this.resolveUpgradesIncluding(2)) {
            count += ((IUpgradeItem)this.getUpgradeForSlot(2)).getUpgradeSize(ItemStack.field_190927_a);
        }
        return count;
    }

    public int getTotalUpgradesQuantity() {
        int count = 0;
        if (this.getIsUpgradePresent(0)) {
            ++count;
        }
        if (this.getIsUpgradePresent(1)) {
            ++count;
        }
        if (this.getIsUpgradePresent(2)) {
            ++count;
        }
        return count;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.getUpgradeForSlot(slot) == stack.func_77973_b() && this.resolveUpgradesUntil(slot)) {
            this.upgrades[slot] = true;
        }
        this.onContentsChanged();
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot < 3 && this.upgrades[slot]) {
            return new ItemStack(this.getUpgradeForSlot(slot));
        }
        return ItemStack.field_190927_a;
    }

    public void onContentsChanged() {
    }
}

