/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import com.aranaira.arcanearchives.types.lists.ManifestList;
import com.aranaira.arcanearchives.util.ManifestUtils;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ManifestItemHandler
implements IItemHandlerModifiable {
    private ManifestList manifestBase;
    private ManifestList manifestActive = null;
    private int numSlots;

    public ManifestItemHandler(ManifestList manifest) {
        this.manifestBase = manifest;
        this.numSlots = 81;
    }

    private void updateManifest() {
        if (this.manifestActive == null) {
            this.manifestActive = this.manifestBase.sorted().filtered();
        }
    }

    public int getSlots() {
        return this.numSlots;
    }

    public void setSlots(int numSlots) {
        this.numSlots = numSlots;
    }

    public ItemStack getStackInSlot(int slot) {
        this.updateManifest();
        return this.manifestActive.getItemStackForSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    @Nullable
    public ManifestUtils.CollatedEntry getManifestEntryInSlot(int slot) {
        this.updateManifest();
        return this.manifestActive.getEntryForSlot(slot);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
    }

    public String getSearchText() {
        return this.manifestBase.getSearchText();
    }

    public ItemStack getSearchItem() {
        return this.manifestBase.getSearchItem();
    }

    public void setSearchText(String s) {
        this.manifestBase.setSearchText(s);
        this.manifestActive = this.manifestBase.sorted().filtered();
    }

    public void setSearchItem(ItemStack s) {
        this.manifestBase.setSearchItem(s);
        this.manifestActive = this.manifestBase.sorted().filtered();
    }

    public void clear() {
        this.manifestBase.setSearchText(null);
        this.manifestBase.setSearchItem(ItemStack.field_190927_a);
        this.manifestActive = this.manifestBase.sorted().filtered();
    }

    public void nullify() {
        this.manifestActive = null;
    }

    public ManifestList.SortingDirection getSortingDirection() {
        if (this.manifestActive != null) {
            return this.manifestActive.getSortingDirection();
        }
        return this.manifestBase.getSortingDirection();
    }

    public void setSortingDirection(ManifestList.SortingDirection sortingDirection) {
        this.manifestBase.setSortingDirection(sortingDirection);
        this.manifestActive = this.manifestBase.sorted().filtered();
    }

    public ManifestList.SortingType getSortingType() {
        if (this.manifestActive != null) {
            return this.manifestActive.getSortingType();
        }
        return this.manifestBase.getSortingType();
    }

    public void setSortingType(ManifestList.SortingType sortingType) {
        this.manifestBase.setSortingType(sortingType);
        this.manifestActive = this.manifestBase.sorted().filtered();
    }
}

