/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import javax.annotation.Nonnull;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class InventoryCraftingItemHandler<T extends TileEntity, V extends IItemHandlerModifiable>
extends InventoryCrafting {
    private final int length;
    private final Container eventHandler;
    private final V parent;
    private final T tile;
    private boolean doNotCallUpdates;

    public InventoryCraftingItemHandler(Container eventHandler, V parent, T tile, int width, int height) {
        super(eventHandler, width, height);
        this.tile = tile;
        this.parent = parent;
        this.length = width * height;
        this.eventHandler = eventHandler;
        this.doNotCallUpdates = false;
    }

    public String getCommandSenderName() {
        return "container.crafting";
    }

    public int func_70302_i_() {
        return this.length;
    }

    @Nonnull
    public ItemStack getStackInSlotOnClosing(int index) {
        return ItemStack.field_190927_a;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.parent.getSlots(); ++i) {
            ItemStack slot = this.parent.getStackInSlot(i);
            if (slot.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void setDoNotCallUpdates(boolean doNotCallUpdates) {
        this.doNotCallUpdates = doNotCallUpdates;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return index >= this.func_70302_i_() ? ItemStack.field_190927_a : this.parent.getStackInSlot(index);
    }

    public boolean func_145818_k_() {
        return false;
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        if (!this.func_70301_a(index).func_190926_b()) {
            if (this.func_70301_a(index).func_190916_E() <= count) {
                ItemStack itemstack = this.func_70301_a(index);
                this.func_70299_a(index, ItemStack.field_190927_a);
                return itemstack;
            }
            ItemStack itemstack = this.func_70301_a(index).func_77979_a(count);
            if (this.func_70301_a(index).func_190916_E() == 0) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            }
            this.onCraftMatrixChanged();
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.parent.setStackInSlot(index, stack);
        this.onCraftMatrixChanged();
    }

    public void func_70296_d() {
        this.tile.func_70296_d();
    }

    public void func_174888_l() {
    }

    public void onCraftMatrixChanged() {
        if (!this.doNotCallUpdates) {
            this.eventHandler.func_75130_a((IInventory)this);
        }
    }
}

