/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory.handlers;

import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.integration.baubles.BaubleGemUtil;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GemSocketHandler
implements INBTSerializable<NBTTagCompound> {
    private int baubleSlot = -1;
    private ItemStack socket;
    private ItemStackHandler handler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ArcaneGemItem;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            GemSocketHandler.this.saveToStack();
        }
    };

    public GemSocketHandler(ItemStack socket) {
        this.socket = socket;
    }

    public int getBaubleSlot() {
        return this.baubleSlot;
    }

    public void setBaubleSlot(int baubleSlot) {
        this.baubleSlot = baubleSlot;
    }

    public NBTTagCompound serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.handler.deserializeNBT(nbt);
    }

    public ItemStack getGem() {
        return this.handler.getStackInSlot(0);
    }

    public ItemStackHandler getInventory() {
        return this.handler;
    }

    public static ItemStack findSocket(EntityPlayer player) {
        ItemStack stack;
        if (player.func_184614_ca().func_77973_b() == ItemRegistry.BAUBLE_GEMSOCKET) {
            return player.func_184614_ca();
        }
        if (Loader.isModLoaded((String)"baubles") && !(stack = BaubleGemUtil.findSocket(player)).func_190926_b()) {
            return stack;
        }
        IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < playerInventory.getSlots(); ++i) {
            ItemStack stack2 = playerInventory.getStackInSlot(i);
            if (stack2.func_77973_b() != ItemRegistry.BAUBLE_GEMSOCKET) continue;
            return stack2;
        }
        return ItemStack.field_190927_a;
    }

    public static GemSocketHandler getHandler(ItemStack stack) {
        GemSocketHandler handler = new GemSocketHandler(stack);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("gem")) {
            handler.deserializeNBT(stack.func_77978_p().func_74775_l("gem"));
        }
        return handler;
    }

    public void saveToStack() {
        NBTTagCompound nbt = this.socket.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            this.socket.func_77982_d(nbt);
        }
        nbt.func_74782_a("gem", (NBTBase)this.serializeNBT());
    }
}

