/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory;

import com.aranaira.arcanearchives.client.gui.framework.CustomCountSlot;
import com.aranaira.arcanearchives.client.gui.framework.IScrollabe;
import com.aranaira.arcanearchives.client.gui.framework.IScrollableContainer;
import com.aranaira.arcanearchives.client.gui.framework.ScrollEventManager;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.ClientNetwork;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.inventory.handlers.ManifestItemHandler;
import com.aranaira.arcanearchives.types.lists.ManifestList;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import com.aranaira.arcanearchives.util.ManifestUtils;
import com.aranaira.arcanearchives.util.MathUtils;
import invtweaks.api.container.InventoryContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

@InventoryContainer
public class ContainerManifest
extends Container
implements IScrollableContainer {
    private static int SCROLL_STEP = 6;
    private static int GRID_SPACING = 18;
    public static int FIRST_CELL_X = 12;
    public static int FIRST_CELL_Y = 30;
    private static int NUM_CELLS = 9;
    private ClientNetwork clientNetwork;
    private ManifestItemHandler handler;
    private boolean serverSide = false;
    private EntityPlayer player;
    private ScrollEventManager scrollEventManager;
    private final List<ManifestItemSlot> manifestItemSlots;
    private int mMaxYOffset;

    public ContainerManifest(EntityPlayer playerIn) {
        this.player = playerIn;
        this.scrollEventManager = null;
        this.manifestItemSlots = new ArrayList<ManifestItemSlot>();
        this.clientNetwork = DataHelper.getClientNetwork(this.player.func_110124_au());
        this.handler = this.clientNetwork.getManifestHandler();
    }

    public void setScrollEventManager(ScrollEventManager scrollEventManager) {
        this.scrollEventManager = scrollEventManager;
        this.scrollEventManager.registerListener(this);
    }

    @Override
    public void registerScrollEventManager(ScrollEventManager scrollEventManager) {
        if (this.scrollEventManager != null) {
            this.scrollEventManager.setStepsPerPage(1);
            this.scrollEventManager.unregisterListener(this);
        }
        this.scrollEventManager = scrollEventManager;
        this.scrollEventManager.setStepsPerPage(GRID_SPACING / SCROLL_STEP * NUM_CELLS);
    }

    @Override
    public List<? extends IScrollabe> getScrollable() {
        return this.manifestItemSlots;
    }

    @Override
    public int getMaxYOffset() {
        return this.mMaxYOffset;
    }

    protected Slot func_75146_a(Slot slotIn) {
        if (slotIn instanceof ManifestItemSlot) {
            this.manifestItemSlots.add((ManifestItemSlot)slotIn);
        }
        return super.func_75146_a(slotIn);
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.field_75151_b.size()) {
            this.mMaxYOffset = ((capacity + (NUM_CELLS - 1)) / NUM_CELLS - NUM_CELLS) * GRID_SPACING;
            this.handler.setSlots(capacity);
            for (int i = this.field_75153_a.size(); i < capacity; ++i) {
                this.func_75146_a((Slot)new ManifestItemSlot((IItemHandler)this.handler, i, i % NUM_CELLS * GRID_SPACING + FIRST_CELL_X, i / NUM_CELLS * GRID_SPACING + FIRST_CELL_Y));
            }
            if (this.scrollEventManager != null) {
                this.scrollEventManager.setNumSteps(Math.max(0, MathUtils.intDivisionCeiling(this.mMaxYOffset, SCROLL_STEP)));
            }
        }
    }

    @Nullable
    public ManifestUtils.CollatedEntry getEntry(int slotId) {
        return this.handler.getManifestEntryInSlot(slotId);
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (this.serverSide) {
            return ItemStack.field_190927_a;
        }
        ManifestUtils.CollatedEntry entry = this.handler.getManifestEntryInSlot(slotId);
        if (entry == null) {
            return ItemStack.field_190927_a;
        }
        if (entry.descriptions.get((int)0).dimension != player.field_71093_bK) {
            return ItemStack.field_190927_a;
        }
        if (dragType == 0) {
            ManifestTrackingUtils.add(entry);
        } else if (dragType == 1) {
            ManifestTrackingUtils.remove(entry);
        }
        if (ConfigHandler.ManifestConfig.holdShift && !GuiScreen.func_146272_n() && dragType == 0 || !ConfigHandler.ManifestConfig.holdShift && GuiScreen.func_146272_n() && dragType == 0) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71439_g.func_71053_j();
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    public void setSearchString(String SearchText) {
        this.handler.setSearchText(SearchText);
        this.handler.setSearchItem(null);
    }

    public String getSearchString() {
        if (this.handler.getSearchItem() != null) {
            return this.handler.getSearchItem().func_82833_r();
        }
        return this.handler.getSearchText();
    }

    public ManifestList.SortingType getSortingType() {
        return this.handler.getSortingType();
    }

    public ManifestList.SortingDirection getSortingDirection() {
        return this.handler.getSortingDirection();
    }

    public void setSortingType(ManifestList.SortingType type) {
        this.handler.setSortingType(type);
    }

    public void setSortingDirection(ManifestList.SortingDirection direction) {
        this.handler.setSortingDirection(direction);
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        Slot slot = this.func_75139_a(slotID);
        if (slot != null) {
            super.func_75141_a(slotID, stack);
        }
    }

    @Nullable
    public Slot func_75139_a(int slotId) {
        try {
            return super.func_75139_a(slotId);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private static class ManifestItemSlot
    extends CustomCountSlot
    implements IScrollabe {
        public int originalY;
        private boolean isEnabled;

        private void setIsEnabled() {
            this.isEnabled = this.field_75221_f > FIRST_CELL_Y - GRID_SPACING && this.field_75221_f < FIRST_CELL_Y + NUM_CELLS * GRID_SPACING;
        }

        public ManifestItemSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.originalY = yPosition;
            this.setIsEnabled();
        }

        @Override
        public void updateY(int yOffset) {
            this.field_75221_f = this.originalY - yOffset;
            this.setIsEnabled();
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_111238_b() {
            if (this.func_75211_c().func_190926_b()) {
                return false;
            }
            return this.isEnabled;
        }
    }
}

