/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory;

import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.inventory.slots.SlotRecipeHandler;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketGemCutters;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import com.aranaira.arcanearchives.tileentities.GemCuttersTableTileEntity;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import invtweaks.api.container.InventoryContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

@InventoryContainer
public class ContainerGemCuttersTable
extends Container {
    private static final int SLOT_OUTPUT = 0;
    private final SlotItemHandler slotOutput;
    private final IInventory playerInventory;
    private final IItemHandlerModifiable tileInventory;
    private final IItemHandlerModifiable outputInv;
    private final IItemHandler combinedInventory;
    private final GemCuttersTableTileEntity tile;
    private final EntityPlayer player;
    private final World world;
    private Runnable updateRecipeGUI;
    public Map<ContainerSection, List<Slot>> map = null;

    public ContainerGemCuttersTable(IItemHandlerModifiable tileInventory, final GemCuttersTableTileEntity tile, final EntityPlayer player) {
        int j;
        int i;
        this.tileInventory = tileInventory;
        this.tile = tile;
        this.outputInv = tile.getOutputInventory();
        this.playerInventory = player.field_71071_by;
        this.player = player;
        this.world = player.field_70170_p;
        IItemHandler mainPlayerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        if (!(mainPlayerInv instanceof IItemHandlerModifiable)) {
            throw new IllegalStateException("Expected main player inventory to be modifiable");
        }
        this.combinedInventory = new CombinedInvWrapper(new IItemHandlerModifiable[]{tileInventory, (IItemHandlerModifiable)mainPlayerInv});
        this.slotOutput = new SlotItemHandler((IItemHandler)this.outputInv, 0, 95, 18){

            public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
                IGCTRecipe recipe = tile.getCurrentRecipe();
                recipe.consumeAndHandleInventory(recipe, ContainerGemCuttersTable.this.combinedInventory, player, tile, () -> ((ContainerGemCuttersTable)ContainerGemCuttersTable.this).func_75142_b(), recipe::handleItemResult);
                if (!player.field_70170_p.field_72995_K) {
                    stack = recipe.onCrafted(player, stack);
                }
                ContainerGemCuttersTable.this.updateRecipe();
                return super.func_190901_a(player, stack);
            }

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(EntityPlayer player2) {
                return tile.getCurrentRecipe().matches(ContainerGemCuttersTable.this.combinedInventory) && tile.getCurrentRecipe().craftable(player2, tile);
            }
        };
        this.func_75146_a((Slot)this.slotOutput);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot(this.playerInventory, j + i * 9 + 9, 23 + j * 18, 166 + i * 18){

                    public void func_75218_e() {
                        super.func_75218_e();
                        ContainerGemCuttersTable.this.updateRecipe();
                    }
                });
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot(this.playerInventory, k, 23 + k * 18, 224){

                public void func_75218_e() {
                    super.func_75218_e();
                    ContainerGemCuttersTable.this.updateRecipe();
                }
            });
        }
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)tileInventory, i * 9 + j, 23 + j * 18, 105 + i * 18){

                    public void func_75218_e() {
                        super.func_75218_e();
                        ContainerGemCuttersTable.this.updateRecipe();
                    }
                });
            }
        }
        for (int x = 6; x > -1; --x) {
            this.func_75146_a(new SlotRecipeHandler(x, x * 18 + 41, 70, tile));
        }
        this.updateRecipe();
    }

    public void updateRecipe() {
        ItemStack itemstack;
        IGCTRecipe curRecipe;
        if (this.updateRecipeGUI != null) {
            this.updateRecipeGUI.run();
        }
        if ((curRecipe = this.tile.getCurrentRecipe()) != null) {
            itemstack = curRecipe.getRecipeOutput().func_77946_l();
            if (!curRecipe.matches(this.combinedInventory)) {
                this.outputInv.setStackInSlot(0, ItemStack.field_190927_a);
                return;
            }
        } else {
            this.outputInv.setStackInSlot(0, ItemStack.field_190927_a);
            return;
        }
        this.outputInv.setStackInSlot(0, itemstack);
        if (this.tile.getPenultimateRecipe() != this.tile.getLastRecipe()) {
            this.playerInventory.func_70299_a(0, itemstack);
        } else if (this.tile.getPenultimateRecipe() != null && this.tile.getPenultimateRecipe() == this.tile.getLastRecipe() && !ItemStack.func_77989_b((ItemStack)this.tile.getPenultimateRecipe().getRecipeOutput(), (ItemStack)this.tile.getLastRecipe().getRecipeOutput())) {
            this.playerInventory.func_70299_a(0, itemstack);
        }
        if (this.tile.getLastRecipe() != null && !this.world.field_72995_K) {
            Networking.CHANNEL.sendTo((IMessage)new PacketGemCutters.LastRecipe(this.tile.getLastRecipe()), (EntityPlayerMP)this.player);
        }
        this.tile.updatePenultimateRecipe();
    }

    public void setUpdateRecipeGUI(Runnable updateRecipeGUI) {
        this.updateRecipeGUI = updateRecipeGUI;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack original = slot.func_75211_c().func_77946_l();
        ItemStack itemstack = slot.func_75211_c().func_77946_l();
        if (index >= 1 && index <= 36 ? !this.func_75135_a(itemstack, 37, 55, false) : !this.func_75135_a(itemstack, 1, 37, true)) {
            return ItemStack.field_190927_a;
        }
        slot.func_75218_e();
        if (itemstack.func_190916_E() == original.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        slot.func_75215_d(itemstack);
        slot.func_190901_a(this.player, itemstack);
        if (slot.func_75216_d() && slot.func_75211_c().func_190926_b()) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return original;
    }

    @Nonnull
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId == 0) {
            dragType = 0;
        }
        if (slotId >= 54 && slotId <= 68) {
            Slot baseSlot = this.func_75139_a(slotId);
            if (!(baseSlot instanceof SlotRecipeHandler)) {
                return super.func_184996_a(slotId, dragType, clickTypeIn, player);
            }
            SlotRecipeHandler slot = (SlotRecipeHandler)baseSlot;
            if (this.world.field_72995_K) {
                this.tile.setRecipe(slot.getRelativeIndex());
            }
            this.updateRecipe();
            if (player.field_70170_p.field_72995_K) {
                this.updateRecipeGUI.run();
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public boolean func_94530_a(ItemStack p_94530_1_, Slot p_94530_2_) {
        return super.func_94530_a(p_94530_1_, p_94530_2_);
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
    }

    public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
        return true;
    }

    public Map<IGCTRecipe, Boolean> updateRecipeStatus() {
        HashMap<IGCTRecipe, Boolean> map = new HashMap<IGCTRecipe, Boolean>();
        for (IGCTRecipe recipe : GCTRecipeList.instance.getRecipeList()) {
            map.put(recipe, recipe.matches(this.combinedInventory));
        }
        return map;
    }

    public void updateLastRecipeFromServer(IGCTRecipe recipe) {
        this.tile.setLastRecipe(recipe);
        if (recipe != null) {
            this.tileInventory.setStackInSlot(0, recipe.getRecipeOutput());
        }
    }

    public GemCuttersTableTileEntity getTile() {
        return this.tile;
    }

    public List<Slot> getSlotRange(int startSlot, int stopSlot) {
        ArrayList<Slot> output = new ArrayList<Slot>();
        for (int i = startSlot; i < stopSlot; ++i) {
            output.add(this.func_75139_a(i));
        }
        return output;
    }

    @ContainerSectionCallback
    public Map<ContainerSection, List<Slot>> containerSectionListMap() {
        if (this.map == null) {
            this.map = new HashMap<ContainerSection, List<Slot>>();
            this.map.put(ContainerSection.INVENTORY, this.getSlotRange(1, 37));
            this.map.put(ContainerSection.CHEST, this.getSlotRange(37, 55));
            this.map.put(ContainerSection.CRAFTING_OUT, Collections.singletonList(this.slotOutput));
        }
        return this.map;
    }
}

