/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.inventory;

import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.inventory.handlers.DevouringCharmHandler;
import com.aranaira.arcanearchives.inventory.slots.SlotImmutable;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerDevouringCharm
extends Container {
    public boolean FLIPPED = false;
    private DevouringCharmHandler handler;
    private EntityPlayer player;
    private ItemStack socket;

    public ContainerDevouringCharm(EntityPlayer player) {
        this.player = player;
        this.socket = player.func_184614_ca();
        this.handler = DevouringCharmHandler.getHandler(this.socket);
        this.createPlayerInventory(player.field_71071_by);
        this.createBucketSlot();
        this.createVoidSlots();
        this.createAutoVoidSlots();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return true;
    }

    private void createBucketSlot() {
        int xOffset = 82;
        int yOffset = 71;
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler.getInventory(), 0, xOffset, yOffset){

            private ItemStack consumeFluid(ItemStack stack) {
                if (!stack.func_190926_b()) {
                    if (stack.func_77973_b() == ItemRegistry.PARCHTEAR) {
                        GemUtil.manuallyRestoreCharge(stack, -1);
                    } else {
                        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                        if (cap != null) {
                            boolean didDrain = false;
                            for (IFluidTankProperties props : cap.getTankProperties()) {
                                FluidStack drain = props.getContents();
                                FluidStack result = cap.drain(drain, true);
                                if (result == null || result.amount <= 0) continue;
                                didDrain = true;
                            }
                            if (didDrain && (stack.func_77973_b() instanceof ItemBucket || stack.func_77973_b() instanceof UniversalBucket)) {
                                stack = cap.getContainer();
                            }
                        }
                    }
                }
                return stack;
            }

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || stack.func_77973_b() == ItemRegistry.PARCHTEAR) && stack.func_77973_b() != ItemRegistry.RADIANT_AMPHORA;
            }

            public void func_75215_d(@Nonnull ItemStack stack) {
                super.func_75215_d(this.consumeFluid(stack));
            }

            public boolean func_111238_b() {
                return !ContainerDevouringCharm.this.FLIPPED;
            }
        });
    }

    private void createVoidSlots() {
        int xOffset = 64;
        int yOffset = 113;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.handler.getInventory(), j + i * 3 + 1, xOffset + j * 18, yOffset + i * 18){

                    public boolean func_111238_b() {
                        return !ContainerDevouringCharm.this.FLIPPED;
                    }
                });
            }
        }
    }

    private void createAutoVoidSlots() {
        int xOffset = 58;
        int yOffset = 99;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a((Slot)new SlotAutovoidHandler((IItemHandler)this.handler.getAutovoidInventory(), j + i * 3, xOffset + j * 24, yOffset + i * 24));
            }
        }
    }

    private void createPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        int xOffset = 10;
        int yOffset = 165;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = j + i * 9 + 9;
                if (inventoryPlayer.func_70301_a(index).func_77973_b() == ItemRegistry.DEVOURING_CHARM) {
                    this.func_75146_a(new SlotImmutable((IInventory)inventoryPlayer, index, xOffset + j * 18, yOffset + i * 18));
                    continue;
                }
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, index, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (inventoryPlayer.func_70301_a(i).func_77973_b() == ItemRegistry.DEVOURING_CHARM) {
                this.func_75146_a(new SlotImmutable((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, xOffset + i * 18, yOffset + 58));
        }
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack slotStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (this.FLIPPED) {
            return ItemStack.field_190927_a;
        }
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            if (stack.func_77973_b() == ItemRegistry.DEVOURING_CHARM) {
                return ItemStack.field_190927_a;
            }
            slotStack = stack.func_77946_l();
            if (index < 36) {
                if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                    Slot fluid = this.func_75139_a(36);
                    IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                    if (ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)fluid.func_75211_c(), (boolean)false).func_190926_b()) {
                        fluid.func_75215_d(ItemStack.field_190927_a);
                    }
                    if (!this.func_75135_a(stack, 36, 37, false)) {
                        return ItemStack.field_190927_a;
                    }
                }
                if (!this.func_75135_a(stack, 36, 43, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(stack, 27, 36, false) && !this.func_75135_a(stack, 0, 27, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
        }
        return slotStack;
    }

    public void func_75134_a(EntityPlayer player) {
        Slot fluid = this.func_75139_a(36);
        if (fluid.func_75216_d()) {
            ItemStack slotItem = fluid.func_75211_c();
            IItemHandler playerInventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)playerInventory, (ItemStack)slotItem, (boolean)false);
            if (!result.func_190926_b() && !player.field_70170_p.field_72995_K) {
                Block.func_180635_a((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (ItemStack)result);
            }
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof SlotAutovoidHandler) {
            if (dragType == 2) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(player.field_71071_by.func_70445_o());
            }
            return player.field_71071_by.func_70445_o();
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public class SlotAutovoidHandler
    extends SlotItemHandler {
        public SlotAutovoidHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            this.getItemHandler().insertItem(this.getSlotIndex(), stack, false);
        }

        public boolean func_82869_a(EntityPlayer playerIn) {
            return true;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return true;
        }

        public boolean func_111238_b() {
            return ContainerDevouringCharm.this.FLIPPED;
        }

        public int func_178170_b(@Nonnull ItemStack stack) {
            return 1;
        }
    }
}

