/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.integration.jei;

import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.integration.jei.CraftingStationRecipeTransferInfo;
import com.aranaira.arcanearchives.integration.jei.gct.GCTCategory;
import com.aranaira.arcanearchives.integration.jei.gct.GCTWrapper;
import com.aranaira.arcanearchives.integration.jei.quartz.QuartzCategory;
import com.aranaira.arcanearchives.integration.jei.quartz.QuartzWrapper;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipe;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static final String GEM_CUTTERS_TABLE = "arcanearchives.gem_cutters_table";
    public static final String RADIANT_RESONATOR = "arcanearchives.radiant_resonator";
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 3;
    public static IJeiHelpers jeiHelpers;
    public static ICraftingGridHelper craftingGridHelper;
    public static IRecipeRegistry recipeRegistry;
    public static IIngredientRegistry itemRegistry;
    public static IJeiRuntime runtime;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new GCTCategory(helper), new QuartzCategory(helper)});
    }

    public void register(@Nonnull IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        itemRegistry = registry.getIngredientRegistry();
        craftingGridHelper = guiHelper.createCraftingGridHelper(3, 0);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new CraftingStationRecipeTransferInfo());
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.RADIANT_CRAFTING_TABLE, 1, 0), new String[]{"minecraft.crafting"});
        registry.handleRecipes(GCTRecipe.class, GCTWrapper::new, GEM_CUTTERS_TABLE);
        registry.addRecipes(GCTRecipeList.instance.getRecipeList(), GEM_CUTTERS_TABLE);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.GEMCUTTERS_TABLE), new String[]{GEM_CUTTERS_TABLE});
        registry.handleRecipes(QuartzWrapper.FakeQuartzRecipe.class, QuartzWrapper::new, RADIANT_RESONATOR);
        registry.addRecipes(Collections.singletonList(new QuartzWrapper.FakeQuartzRecipe()), RADIANT_RESONATOR);
        registry.addRecipeCatalyst((Object)new ItemStack((Block)BlockRegistry.RADIANT_RESONATOR), new String[]{RADIANT_RESONATOR});
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        recipeRegistry = jeiRuntime.getRecipeRegistry();
        if (!ConfigHandler.ArsenalConfig.EnableArsenal) {
            itemRegistry.removeIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)ItemRegistry.ARSENAL_ITEMS.stream().map(ItemStack::new).collect(Collectors.toList()));
        } else {
            itemRegistry.removeIngredientsAtRuntime(VanillaTypes.ITEM, Collections.singletonList(new ItemStack((Item)ItemRegistry.GBOOK_ARSENAL_CONDITION)));
        }
        NonNullList ignores = NonNullList.func_191196_a();
        ItemRegistry.CHROMATIC_POWDER.func_150895_a(CreativeTabs.field_78027_g, (NonNullList<ItemStack>)ignores);
        ignores.add((Object)new ItemStack((Item)ItemRegistry.CHROMATIC_POWDER));
        ignores.add((Object)new ItemStack((Item)ItemRegistry.RAINBOW_CHROMATIC_POWDER));
        itemRegistry.removeIngredientsAtRuntime(VanillaTypes.ITEM, (Collection)ignores);
    }
}

