/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.integration.crafttweaker;

import com.aranaira.arcanearchives.api.IGCTRecipe;
import com.aranaira.arcanearchives.integration.crafttweaker.Action;
import com.aranaira.arcanearchives.recipe.IngredientStack;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipe;
import com.aranaira.arcanearchives.recipe.gct.GCTRecipeList;
import com.aranaira.arcanearchives.util.zen.ZenDocAppend;
import com.aranaira.arcanearchives.util.zen.ZenDocArg;
import com.aranaira.arcanearchives.util.zen.ZenDocClass;
import com.aranaira.arcanearchives.util.zen.ZenDocMethod;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.CraftTweaker;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenDocClass(value="mods.arcanearchives.GCT")
@ZenDocAppend(value={"docs/include/gct.example.md"})
@ZenRegister
@ZenClass(value="mods.arcanearchives.GCT")
public class GCTTweaker {
    @ZenDocMethod(order=1, args={@ZenDocArg(arg="name", info="the recipe name"), @ZenDocArg(arg="output", info="the output as an itemstack"), @ZenDocArg(arg="inputs", info="the inputs as an array of ingredients")})
    @ZenMethod
    public static void addRecipe(String name, IItemStack output, IIngredient[] inputs) {
        CraftTweaker.LATE_ACTIONS.add(new Add(name, CraftTweakerMC.getItemStack((IItemStack)output), inputs, false));
    }

    @ZenDocMethod(order=2, args={@ZenDocArg(arg="output", info="the output itemstack to be removed (quantity must match)")})
    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweaker.LATE_ACTIONS.add(new Remove(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    @ZenDocMethod(order=3, args={@ZenDocArg(arg="name", info="the recipe name (must already exist)"), @ZenDocArg(arg="output", info="the output as an itemstack"), @ZenDocArg(arg="inputs", info="the inputs as an array of ingredients")})
    @ZenMethod
    public static void replaceRecipe(String name, IItemStack output, IIngredient[] inputs) {
        CraftTweaker.LATE_ACTIONS.add(new Add(name, CraftTweakerMC.getItemStack((IItemStack)output), inputs, true));
    }

    private static class Add
    extends Action {
        private final ResourceLocation name;
        private final ItemStack output;
        private final IIngredient[] ingredients;
        private final boolean replace;

        private Add(String name, ItemStack output, IIngredient[] ingredients, boolean replace) {
            super("GCT Recipe addition");
            this.name = new ResourceLocation("arcanearchives", name);
            this.output = output;
            this.ingredients = ingredients;
            this.replace = replace;
        }

        public void apply() {
            if (this.replace && GCTRecipeList.instance.getRecipe(this.name) == null) {
                CraftTweakerAPI.logError((String)("Attempting to replace recipe " + this.name.toString() + " when it doesn't exist. Use addRecipe instead."));
                return;
            }
            ArrayList<IngredientStack> stacks = new ArrayList<IngredientStack>();
            for (IIngredient ingredient : this.ingredients) {
                stacks.add(new IngredientStack(CraftTweakerMC.getIngredient((IIngredient)ingredient), ingredient.getAmount()));
            }
            GCTRecipe recipe = new GCTRecipe(this.name, this.output, stacks);
            GCTRecipeList.instance.addRecipe(recipe);
        }

        public String describe() {
            return "Adding GCT recipe for " + this.output.toString();
        }
    }

    private static class Remove
    extends Action {
        private ItemStack output;

        private Remove(ItemStack stack) {
            super("GCT Recipe removal");
            this.output = stack;
        }

        public String describe() {
            return "Removing " + this.output.func_77973_b().getRegistryName().toString();
        }

        public void apply() {
            IGCTRecipe recipe = GCTRecipeList.instance.getRecipeByOutput(this.output);
            if (recipe == null) {
                CraftTweakerAPI.logError((String)("Invalid recipe for " + this.output.func_77973_b().getRegistryName().toString()));
            } else {
                GCTRecipeList.instance.removeRecipe(recipe);
            }
        }
    }
}

