/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.events;

import com.aranaira.arcanearchives.client.render.LineHandler;
import com.aranaira.arcanearchives.client.render.RenderGemcasting;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.PlayerSaveData;
import com.aranaira.arcanearchives.entity.EntityItemMountaintear;
import com.aranaira.arcanearchives.entity.ai.AIResonatorSit;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.integration.baubles.BaubleBodyCapabilityHandler;
import com.aranaira.arcanearchives.inventory.handlers.DevouringCharmHandler;
import com.aranaira.arcanearchives.items.RadiantAmphoraItem;
import com.aranaira.arcanearchives.items.TomeOfArcanaItem;
import com.aranaira.arcanearchives.items.gems.ArcaneGemItem;
import com.aranaira.arcanearchives.items.gems.GemUtil;
import com.aranaira.arcanearchives.items.gems.asscher.AgegleamItem;
import com.aranaira.arcanearchives.items.gems.asscher.MurdergleamItem;
import com.aranaira.arcanearchives.items.gems.asscher.SalvegleamItem;
import com.aranaira.arcanearchives.items.gems.asscher.Slaughtergleam;
import com.aranaira.arcanearchives.items.gems.pampel.Elixirspindle;
import com.aranaira.arcanearchives.items.gems.trillion.StormwayItem;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketArcaneGems;
import com.aranaira.arcanearchives.network.PacketConfig;
import com.aranaira.arcanearchives.network.PacketRadiantAmphora;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantTroveTileEntity;
import com.aranaira.arcanearchives.types.iterators.SlotIterable;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import epicsquid.mysticallib.util.Util;
import gigaherz.lirelent.guidebook.client.BookRegistryEvent;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBookshelf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.common.tiles.crafting.TileCrucible;
import vazkii.botania.api.item.IPetalApothecary;

@Mod.EventBusSubscriber
public class EventHandler {
    public static Object2LongOpenHashMap<EntityPlayer> shouldPlaySound = new Object2LongOpenHashMap();

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            PacketConfig.RequestMaxDistance packet = new PacketConfig.RequestMaxDistance();
            Networking.CHANNEL.sendTo((IMessage)packet, (EntityPlayerMP)player);
            PacketConfig.RequestDefaultRoutingType packet2 = new PacketConfig.RequestDefaultRoutingType();
            Networking.CHANNEL.sendTo((IMessage)packet2, (EntityPlayerMP)player);
            PacketConfig.RequestTrovesDispense packet3 = new PacketConfig.RequestTrovesDispense();
            Networking.CHANNEL.sendTo((IMessage)packet3, (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public static void onBlockBreakEvent(BlockEvent.BreakEvent event) {
        RadiantTroveTileEntity te;
        if (!ConfigHandler.UnbreakableContainers) {
            return;
        }
        World w = event.getWorld();
        Block block = event.getState().func_177230_c();
        if (!w.field_72995_K && block == BlockRegistry.RADIANT_CHEST) {
            RadiantChestTileEntity te2 = WorldUtil.getTileEntity(RadiantChestTileEntity.class, (IBlockAccess)w, event.getPos());
            if (te2 == null) {
                return;
            }
            IItemHandler handler = (IItemHandler)te2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (handler == null) {
                return;
            }
            boolean allSlotsEmpty = true;
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (handler.getStackInSlot(i).func_190926_b()) continue;
                allSlotsEmpty = false;
                break;
            }
            if (!allSlotsEmpty) {
                event.setCanceled(true);
            }
        } else if (!w.field_72995_K && block == BlockRegistry.RADIANT_TROVE && (te = WorldUtil.getTileEntity(RadiantTroveTileEntity.class, (IBlockAccess)w, event.getPos())) != null && !te.isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyBlockEvent(LivingDestroyBlockEvent event) {
        if (!ConfigHandler.UnbreakableContainers) {
            return;
        }
        Block block = event.getState().func_177230_c();
        if (block == BlockRegistry.RADIANT_CHEST || block == BlockRegistry.RADIANT_TROVE) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        LineHandler.removeLine(event.getPos(), event.getEntity().field_71093_bK);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack;
        ArcaneGemItem agi;
        Item item = event.getEntityPlayer().field_71071_by.func_70448_g().func_77973_b();
        if (item == ItemRegistry.RADIANT_AMPHORA) {
            PacketRadiantAmphora.Toggle packet = new PacketRadiantAmphora.Toggle();
            Networking.CHANNEL.sendToServer((IMessage)packet);
        } else if (item instanceof ArcaneGemItem && (agi = (ArcaneGemItem)(stack = event.getEntityPlayer().func_184614_ca()).func_77973_b()).hasToggleMode()) {
            PacketArcaneGems.Toggle packet = new PacketArcaneGems.Toggle();
            Networking.CHANNEL.sendToServer((IMessage)packet);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            Item item = event.getEntityPlayer().field_71071_by.func_70448_g().func_77973_b();
            if (item == ItemRegistry.RADIANT_AMPHORA && event.getEntityPlayer().func_70093_af()) {
                ItemStack stack = event.getEntityPlayer().func_184614_ca();
                RadiantAmphoraItem.AmphoraUtil util = new RadiantAmphoraItem.AmphoraUtil(stack);
                util.toggleMode();
            } else if (item == ItemRegistry.RAW_RADIANT_QUARTZ) {
                ItemStack stack = event.getEntityPlayer().func_184614_ca();
                Random rng = new Random();
                int num = rng.nextInt(100);
                if (num <= ConfigHandler.serverSideConfig.ChanceForSliverCluster) {
                    stack.func_190918_g(1);
                    int max = ConfigHandler.serverSideConfig.AmountGeneratedOnSliverClusterMaximum;
                    int min = ConfigHandler.serverSideConfig.AmountGeneratedOnSliverClusterMinimum;
                    num = max - min == 0 ? min : rng.nextInt(max - min) + min;
                    ItemStack shards = new ItemStack((Block)BlockRegistry.QUARTZ_SLIVER, num);
                    Vec3d pos = event.getHitVec();
                    EntityItem ei = new EntityItem(event.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, shards);
                    ei.field_70159_w = rng.nextFloat() * 0.4f - 0.2f;
                    ei.field_70179_y = rng.nextFloat() * 0.4f - 0.2f;
                    ei.field_70181_x = rng.nextFloat() * 0.2f + 0.2f;
                    event.getWorld().func_72838_d((Entity)ei);
                } else if (num <= ConfigHandler.serverSideConfig.ChanceForSliverCluster + ConfigHandler.serverSideConfig.ChanceForSliverSingle) {
                    ItemStack shards = new ItemStack((Block)BlockRegistry.QUARTZ_SLIVER, 1);
                    Vec3d pos = event.getHitVec();
                    EntityItem ei = new EntityItem(event.getWorld(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, shards);
                    ei.field_70159_w = rng.nextFloat() * 0.4f - 0.2f;
                    ei.field_70179_y = rng.nextFloat() * 0.4f - 0.2f;
                    ei.field_70181_x = rng.nextFloat() * 0.2f + 0.2f;
                    event.getWorld().func_72838_d((Entity)ei);
                }
            }
        }
    }

    @Optional.Method(modid="botania")
    public static void tryPetalApothecary(PlayerInteractEvent.RightClickBlock event) {
        boolean hasRivertear;
        IPetalApothecary ipate = WorldUtil.getTileEntity(IPetalApothecary.class, event.getEntity().field_71093_bK, event.getPos());
        if (ipate != null && (hasRivertear = GemUtil.getHasRivertear(event.getEntityPlayer())) && !ipate.hasWater()) {
            ipate.setWater(true);
        }
    }

    @Optional.Method(modid="thaumcraft")
    public static void tryThaumcraftCrucible(PlayerInteractEvent.RightClickBlock event) {
        boolean hasRivertear;
        TileCrucible tc = WorldUtil.getTileEntity(TileCrucible.class, event.getEntity().field_71093_bK, event.getPos());
        if (tc != null && tc.tank.getFluidAmount() == 0 && (hasRivertear = GemUtil.getHasRivertear(event.getEntityPlayer()))) {
            int amount = tc.fill(new FluidStack(FluidRegistry.WATER, 1000), false);
            tc.fill(new FluidStack(FluidRegistry.WATER, amount), true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K) {
            if (Loader.isModLoaded((String)"botania")) {
                EventHandler.tryPetalApothecary(event);
            }
            if (Loader.isModLoaded((String)"thaumcraft")) {
                EventHandler.tryThaumcraftCrucible(event);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void renderGemHUD(RenderGameOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            for (GemUtil.GemStack gem : GemUtil.getAvailableGems((EntityPlayer)player)) {
                RenderGemcasting.EnumGemGuiMode mode = RenderGemcasting.EnumGemGuiMode.SOCKET;
                if (gem.getStack().equals(player.func_184614_ca())) {
                    mode = RenderGemcasting.EnumGemGuiMode.RIGHT;
                } else if (gem.getStack().equals(player.func_184592_cb())) {
                    mode = RenderGemcasting.EnumGemGuiMode.LEFT;
                }
                RenderGemcasting.draw(minecraft, gem.getStack(), event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), mode);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void playerPickupXP(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null) {
            return;
        }
        GemUtil.AvailableGemsHandler held = GemUtil.getAvailableGems(event.getEntityPlayer());
        for (GemUtil.GemStack stack : held) {
            if (stack.getItem() == ItemRegistry.ORDERSTONE) {
                GemUtil.restoreCharge(stack, event.getOrb().field_70530_e);
            }
            if (stack.getItem() != ItemRegistry.MINDSPINDLE || GemUtil.getCharge(stack) <= 0) continue;
            int chargeReduction = event.getOrb().field_70530_e;
            event.getOrb().field_70530_e = Math.round((float)event.getOrb().field_70530_e * 1.5f);
            event.getOrb().field_70532_c = 0;
            GemUtil.consumeCharge(stack, chargeReduction);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingAttackEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            GemUtil.AvailableGemsHandler held = GemUtil.getAvailableGems(player);
            for (GemUtil.GemStack stack : held) {
                if (stack.getItem() != ItemRegistry.PHOENIXWAY || player.func_70644_a(MobEffects.field_76426_n) || GemUtil.getCharge(stack) < 0 || event.getSource() != DamageSource.field_76370_b && event.getSource() != DamageSource.field_76372_a) continue;
                player.func_184185_a(SoundEvents.field_190021_aL, 1.0f, 1.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 600, 0));
                GemUtil.consumeCharge(stack, 12);
                event.setCanceled(true);
            }
        }
    }

    @Optional.Method(modid="gbook_snapshot")
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerBook(BookRegistryEvent event) {
        event.register(TomeOfArcanaItem.TOME_OF_ARCANA, true);
    }

    @SubscribeEvent
    public static void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        ItemStack stack;
        Entity entity = event.getEntity();
        if (entity instanceof EntityOcelot) {
            EntityOcelot ocelot = (EntityOcelot)entity;
            ocelot.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIResonatorSit(ocelot, 0.8));
        } else if (entity instanceof EntityItem && !(entity instanceof EntityItemMountaintear) && (stack = ((EntityItem)entity).func_92059_d()).func_77973_b() == ItemRegistry.MOUNTAINTEAR) {
            if (!event.getWorld().field_72995_K) {
                EntityItemMountaintear mountaintear = new EntityItemMountaintear(event.getWorld(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                mountaintear.func_174869_p();
                mountaintear.field_70159_w = entity.field_70159_w;
                mountaintear.field_70181_x = entity.field_70181_x;
                mountaintear.field_70179_y = entity.field_70179_y;
                event.getWorld().func_72838_d((Entity)mountaintear);
            }
            entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onCriticalHitLanded(CriticalHitEvent event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            for (GemUtil.GemStack stack : GemUtil.getAvailableGems(event.getEntityPlayer())) {
                if (!(stack.getItem() instanceof MurdergleamItem)) continue;
                if (GemUtil.isToggledOn(stack) && GemUtil.getCharge(stack) > 0) {
                    event.setDamageModifier(1.5f);
                    event.setResult(Event.Result.ALLOW);
                    GemUtil.consumeCharge(stack, 1);
                    if (GemUtil.getCharge(stack) != 0) continue;
                    GemUtil.swapToggle(stack);
                    continue;
                }
                if (!event.isVanillaCritical()) continue;
                GemUtil.restoreCharge(stack, 3);
                if (GemUtil.getCharge(stack) != GemUtil.getMaxCharge(stack)) continue;
                GemUtil.swapToggle(stack);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingAttackEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer && event.getSource().func_76346_g() instanceof EntityLiving) {
            EntityLivingBase source = (EntityLivingBase)event.getSource().func_76346_g();
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            for (GemUtil.GemStack gem : GemUtil.getAvailableGems(player)) {
                if (!(gem.getItem() instanceof StormwayItem) || !GemUtil.isToggledOn(gem) || GemUtil.getCharge(gem) <= 0 || !event.getSource().func_76352_a()) continue;
                source.field_70170_p.func_72838_d((Entity)new EntityLightningBolt(source.field_70170_p, source.field_70165_t, source.field_70163_u + 0.5, source.field_70161_v, false));
                if (source.func_70662_br()) {
                    source.func_70690_d(new PotionEffect(MobEffects.field_76432_h, 1, 10));
                } else {
                    source.func_70690_d(new PotionEffect(MobEffects.field_76433_i, 1, 10));
                }
                GemUtil.consumeCharge(gem, 1);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityStruckbyLightning(EntityStruckByLightningEvent event) {
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (GemUtil.GemStack gem : GemUtil.getAvailableGems(player)) {
                if (!(gem.getItem() instanceof StormwayItem) || GemUtil.getCharge(gem) <= 0 || !StormwayItem.canBeStruck(gem)) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 1200, 2));
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 1200, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 1200, 0));
                GemUtil.consumeCharge(gem, 6);
                StormwayItem.setStrikeCooldownTimer(gem);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            for (GemUtil.GemStack gem : GemUtil.getAvailableGems(player)) {
                if (gem.getItem() == ItemRegistry.SALVEGLEAM) {
                    if (GemUtil.getCharge(gem) <= 0 || !GemUtil.isToggledOn(gem) || !(player.func_110143_aJ() < player.func_110138_aP()) || !SalvegleamItem.canDoHealingPulse(gem)) continue;
                    player.func_70691_i(1.0f);
                    GemUtil.consumeCharge(gem, 1);
                    if (GemUtil.getCharge(gem) != 0) continue;
                    GemUtil.setToggle(gem, false);
                    continue;
                }
                if (gem.getItem() == ItemRegistry.STORMWAY) {
                    if (GemUtil.getCharge(gem) >= GemUtil.getMaxCharge(gem) || !player.field_70170_p.func_72896_J()) continue;
                    GemUtil.restoreCharge(gem, -1);
                    player.func_184185_a(SoundEvents.field_190021_aL, 1.0f, 1.0f);
                    continue;
                }
                if (gem.getItem() != ItemRegistry.AGEGLEAM || GemUtil.getCharge(gem) >= GemUtil.getMaxCharge(gem)) continue;
                AgegleamItem.processRechargeTime(gem);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAttackEntity(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)event.getEntityLiving();
            if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                for (GemUtil.GemStack gem : GemUtil.getAvailableGems((EntityPlayer)event.getSource().func_76346_g())) {
                    if (!(gem.getItem() instanceof SalvegleamItem)) continue;
                    GemUtil.restoreCharge(gem, (int)event.getEntityLiving().func_110138_aP() / 2);
                    if (GemUtil.getCharge(gem) != GemUtil.getMaxCharge(gem)) continue;
                    GemUtil.setToggle(gem, true);
                }
            }
        }
    }

    private static void givePlayerBookMaybe(EntityPlayer player, World world, boolean bookshelf) {
        PlayerSaveData save = DataHelper.getPlayerData(player);
        if (save.receivedBook) {
            return;
        }
        save.receivedBook = true;
        save.func_76185_a();
        ItemStack tome = new ItemStack((Item)ItemRegistry.TOME_OF_ARCANA);
        NBTTagCompound tag = ItemUtils.getOrCreateTagCompound(tome);
        tag.func_74778_a("Book", TomeOfArcanaItem.TOME_OF_ARCANA.toString());
        Objects.requireNonNull(world.func_175693_T()).func_75744_a();
        EntityItem tomeEntity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, tome);
        tomeEntity.func_174867_a(0);
        if (bookshelf) {
            player.func_145747_a(new TextComponentTranslation("arcanearchives.message.book_received.bookshelf", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        } else {
            player.func_145747_a(new TextComponentTranslation("arcanearchives.message.book_received.resonator", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        }
        world.func_72838_d((Entity)tomeEntity);
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187548_af, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public static void onPlayerBreakBlock(BlockEvent.BreakEvent event) {
        if (ConfigHandler.serverSideConfig.BookFromBookshelf && !event.getWorld().field_72995_K && event.getState().func_177230_c() instanceof BlockBookshelf) {
            EventHandler.givePlayerBookMaybe(event.getPlayer(), event.getWorld(), true);
        }
    }

    @SubscribeEvent
    public static void onPlayerCrafted(PlayerEvent.ItemCraftedEvent event) {
        if (!event.player.field_70170_p.field_72995_K && ConfigHandler.serverSideConfig.BookFromResonator) {
            Item item = event.crafting.func_77973_b();
            if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() == BlockRegistry.RADIANT_RESONATOR) {
                EventHandler.givePlayerBookMaybe(event.player, event.player.field_70170_p, false);
            } else if (item == ItemRegistry.TOME_OF_ARCANA) {
                World world = event.player.field_70170_p;
                EntityPlayer player = event.player;
                PlayerSaveData save = DataHelper.getPlayerData(player);
                save.receivedBook = true;
                save.func_76185_a();
                Objects.requireNonNull(world.func_175693_T()).func_75744_a();
            }
        }
    }

    @SubscribeEvent
    public static void onItemUse(LivingEntityUseItemEvent event) {
        block6: {
            block5: {
                if (event.getEntityLiving().field_70170_p.field_72995_K || !(event.getEntityLiving() instanceof EntityPlayer)) break block5;
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                ItemStack stack = player.func_184614_ca();
                for (GemUtil.GemStack gem : GemUtil.getAvailableGems(player)) {
                    if (!(gem.getItem() instanceof Elixirspindle) || GemUtil.getCharge(gem) <= 0 || !(stack.func_77973_b() instanceof ItemPotion)) continue;
                    PotionType potion = PotionUtils.func_185191_c((ItemStack)player.func_184614_ca());
                    boolean potionAlreadyActive = false;
                    for (PotionEffect effect : potion.func_185170_a()) {
                        if (effect.func_188419_a().func_76403_b() || !player.func_193076_bZ().containsKey(effect.func_188419_a())) continue;
                        potionAlreadyActive = true;
                        break;
                    }
                    if (!potionAlreadyActive) {
                        for (PotionEffect effect : PotionUtils.func_185189_a((ItemStack)player.func_184614_ca())) {
                            player.func_70690_d(new PotionEffect(effect));
                        }
                        GemUtil.consumeCharge(gem, 1);
                    }
                    event.setCanceled(true);
                }
                break block6;
            }
            if (!event.getEntityLiving().field_70170_p.field_72995_K || !(event.getEntityLiving() instanceof EntityPlayer)) break block6;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = player.func_184614_ca();
            for (GemUtil.GemStack gem : GemUtil.getAvailableGems(player)) {
                if (!(gem.getItem() instanceof Elixirspindle) || GemUtil.getCharge(gem) <= 0) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLooting(LootingLevelEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getDamageSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getDamageSource().func_76346_g();
            for (GemUtil.GemStack gem : GemUtil.getAvailableGems(player)) {
                if (!(gem.getItem() instanceof Slaughtergleam) || GemUtil.getCharge(gem) <= 0) continue;
                event.setLootingLevel(event.getLootingLevel() + 1);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLivingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            for (GemUtil.GemStack gem : GemUtil.getAvailableGems(player)) {
                if (!(gem.getItem() instanceof Slaughtergleam) || GemUtil.getCharge(gem) <= 0) continue;
                GemUtil.consumeCharge(gem, 1);
            }
        }
    }

    @SubscribeEvent
    public static void onEndermanTeleport(EnderTeleportEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityLivingBase target = event.getEntityLiving();
            double cubeRadius = 10.5;
            AxisAlignedBB aabb = new AxisAlignedBB(target.field_70165_t - cubeRadius, target.field_70163_u - cubeRadius, target.field_70161_v - cubeRadius, target.field_70165_t + cubeRadius, target.field_70163_u + cubeRadius, target.field_70161_v + cubeRadius);
            for (EntityPlayer player : target.field_70170_p.func_72872_a(EntityPlayer.class, aabb)) {
                GemUtil.AvailableGemsHandler handler = GemUtil.getAvailableGems(player);
                for (GemUtil.GemStack gem : handler) {
                    if (gem.getItem() != ItemRegistry.SWITCHGLEAM) continue;
                    GemUtil.restoreCharge(gem, 3);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        if (event.getEntityPlayer() != null) {
            ArrayList<ItemStack> devouringCharms = new ArrayList<ItemStack>();
            EntityPlayer player = event.getEntityPlayer();
            IItemHandler cap = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
            for (ItemStack stack : new SlotIterable(cap)) {
                if (stack.func_77973_b() != ItemRegistry.DEVOURING_CHARM) continue;
                devouringCharms.add(stack);
            }
            long lastPlayed = (Long)shouldPlaySound.getOrDefault((Object)player, (Object)-1L);
            boolean playSound = true;
            if (System.currentTimeMillis() - lastPlayed < 500L && lastPlayed != -1L) {
                playSound = false;
            }
            EntityItem item = event.getItem();
            ItemStack stack = item.func_92059_d();
            for (ItemStack dCharm : devouringCharms) {
                DevouringCharmHandler handler = DevouringCharmHandler.getHandler(dCharm);
                if (!handler.shouldVoidItem(stack)) continue;
                stack.func_190918_g(stack.func_190916_E());
                item.func_70106_y();
                event.setResult(Event.Result.DENY);
                World world = event.getEntityPlayer().field_70170_p;
                if (world.field_72995_K || !playSound) break;
                world.func_184148_a(null, item.field_70165_t, item.field_70163_u, item.field_70161_v, SoundEvents.field_187537_bA, SoundCategory.PLAYERS, 0.4f, 0.7f + Util.rand.nextFloat() * 0.6f);
                shouldPlaySound.put((Object)player, System.currentTimeMillis());
                break;
            }
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="baubles")
    public static void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).func_77973_b() == ItemRegistry.BAUBLE_GEMSOCKET) {
            event.addCapability(BaubleBodyCapabilityHandler.NAME, (ICapabilityProvider)BaubleBodyCapabilityHandler.instance);
        }
    }
}

