/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.data;

import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.HiveMembershipInfo;
import com.aranaira.arcanearchives.data.HiveNetwork;
import com.aranaira.arcanearchives.data.IServerNetwork;
import com.aranaira.arcanearchives.data.SynchroniseInfo;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketNetworks;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantResonatorTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IManifestTileEntity;
import com.aranaira.arcanearchives.tileentities.unused.MatrixCoreTileEntity;
import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.iterators.TileListIterable;
import com.aranaira.arcanearchives.types.lists.ManifestList;
import com.aranaira.arcanearchives.types.lists.TileList;
import com.aranaira.arcanearchives.util.ManifestUtils;
import com.aranaira.arcanearchives.util.TileUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerNetwork
implements IServerNetwork {
    private static ArrayList<ServerNetwork> FAKE_MEMBERS = new ArrayList();
    private UUID uuid;
    private WeakReference<World> world;
    private Boolean isHiveMember;
    private ManifestList manifestItems = new ManifestList((List<ManifestUtils.CollatedEntry>)new ArrayList<ManifestUtils.CollatedEntry>());
    private TileList tiles = new TileList((List<IteRef>)new ArrayList<IteRef>());
    private Set<UUID> tileIdSet = new HashSet<UUID>();
    private Set<UUID> safeLimitedIDs = new HashSet<UUID>();
    private int totalCores = 0;
    private int totalResonators = 0;
    private int maxDistance = 0;
    private boolean defaultRoutingNoNewItems = false;
    private boolean trovesDispense = true;

    public ServerNetwork(UUID id) {
        this.uuid = id;
    }

    public boolean getNoNewDefault() {
        return this.defaultRoutingNoNewItems;
    }

    public void setNoNewDefault(boolean defaultRoutingNoNewItems) {
        this.defaultRoutingNoNewItems = defaultRoutingNoNewItems;
    }

    public int getMaxDistance() {
        return this.maxDistance * this.maxDistance;
    }

    public void setMaxDistance(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    public boolean getTrovesDispense() {
        return this.trovesDispense;
    }

    public void setTrovesDispense(boolean trovesDispense) {
        this.trovesDispense = trovesDispense;
    }

    @Nullable
    public ImmanenceTileEntity getImmanenceTile(UUID tileId) {
        return this.tiles.getByUUID(tileId);
    }

    @Override
    public TileList getTiles() {
        return this.tiles;
    }

    @Override
    public boolean anyLoaded() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (DimensionType i : DimensionType.values()) {
            map.put(i.func_186068_a(), new HashSet());
        }
        for (IteRef ref : this.tiles) {
            ((Set)map.get(ref.dimension)).add(new ChunkPos(ref.pos));
        }
        for (Int2ObjectMap.Entry entry : map.int2ObjectEntrySet()) {
            if (((Set)entry.getValue()).isEmpty()) continue;
            int dimension = entry.getIntKey();
            Set chunks = (Set)entry.getValue();
            WorldServer dimWorld = DimensionManager.getWorld((int)dimension);
            ChunkProviderServer provider = dimWorld.func_72863_F();
            for (ChunkPos pos : chunks) {
                if (!provider.func_73149_a(pos.field_77276_a, pos.field_77275_b)) continue;
                return true;
            }
        }
        return false;
    }

    public void tileEntityMoved(UUID tileId, BlockPos newPosition) {
        IteRef ref = this.getTiles().getReference(tileId);
        if (ref == null) {
            return;
        }
        ref.pos = newPosition;
    }

    public static ServerNetwork fromNBT(NBTTagCompound data) {
        ServerNetwork network = new ServerNetwork(null);
        network.readFromSave(data);
        return network;
    }

    @Override
    public World getWorld() {
        if (this.world == null || this.world.get() == null) {
            this.world = new WeakReference<World>(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_());
        }
        return (World)this.world.get();
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    public boolean isSafe(UUID id) {
        return this.safeLimitedIDs.contains(id);
    }

    @Override
    @Nullable
    public EntityPlayer getPlayer() {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            return server.func_184103_al().func_177451_a(this.uuid);
        }
        return null;
    }

    @Override
    public Iterable<IteRef> getValidTiles() {
        return TileUtils.filterValid(this.tiles);
    }

    @Override
    public UUID generateTileUuid() {
        UUID newId = UUID.randomUUID();
        while (this.tileIdSet.contains(newId)) {
            newId = UUID.randomUUID();
        }
        return newId;
    }

    @Override
    public void handleTileIdChange(UUID oldId, UUID newId) {
        this.tileIdSet.remove(oldId);
        this.tileIdSet.add(newId);
        this.safeLimitedIDs.remove(oldId);
        this.safeLimitedIDs.add(newId);
        this.tiles.updateUUID(oldId, newId);
    }

    @Override
    public void addTile(ImmanenceTileEntity tileEntityInstance) {
        IteRef ref;
        tileEntityInstance.tryGenerateUUID();
        if (this.tiles.containsUUID(tileEntityInstance.uuid) && (ref = this.tiles.getReference(tileEntityInstance.uuid)) != null) {
            ref.networkPriority = tileEntityInstance.getNetworkPriority();
            ref.pos = tileEntityInstance.func_174877_v();
            ref.clazz = ((Object)((Object)tileEntityInstance)).getClass();
            ref.dimension = tileEntityInstance.dimension;
            ref.uuid = tileEntityInstance.getUuid();
            return;
        }
        this.tiles.add(new IteRef(tileEntityInstance));
        tileEntityInstance.hasBeenAddedToNetwork = true;
        if (tileEntityInstance instanceof RadiantResonatorTileEntity || tileEntityInstance instanceof MatrixCoreTileEntity) {
            this.safeLimitedIDs.add(tileEntityInstance.uuid);
            this.rebuildTotals();
        }
        tileEntityInstance.joinedNetwork(this);
    }

    @Override
    public void removeTile(ImmanenceTileEntity te) {
        this.tiles.removeByUUID(te.getUuid());
        if (te instanceof RadiantResonatorTileEntity || te instanceof MatrixCoreTileEntity) {
            this.safeLimitedIDs.remove(te.uuid);
            this.rebuildTotals();
        }
    }

    @Override
    public void removeTile(UUID tileID) {
        ImmanenceTileEntity te = this.tiles.getByUUID(tileID);
        this.removeTile(te);
    }

    @Override
    public boolean containsTile(ImmanenceTileEntity tileEntityInstance) {
        return this.containsTile(tileEntityInstance.uuid);
    }

    @Override
    public boolean containsTile(UUID tileID) {
        return this.tiles.containsUUID(tileID);
    }

    @Override
    public void updateTile(ImmanenceTileEntity tileEntityInstance) {
        this.tiles.updateReference(tileEntityInstance);
    }

    @Override
    public NBTTagCompound writeToSave() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_186854_a("playerId", this.uuid);
        return tagCompound;
    }

    @Override
    public void readFromSave(NBTTagCompound tag) {
        this.uuid = tag.func_186857_a("playerId");
    }

    @Override
    public int getTotalCores() {
        return this.totalCores;
    }

    @Override
    public int getTotalResonators() {
        return this.totalResonators;
    }

    @Override
    public void rebuildTotals() {
        this.totalResonators = 0;
        this.totalCores = 0;
        for (IteRef ite : this.getValidTiles()) {
            if (ite == null) continue;
            if (ite.clazz.equals(RadiantResonatorTileEntity.class)) {
                ++this.totalResonators;
                continue;
            }
            if (!ite.clazz.equals(MatrixCoreTileEntity.class)) continue;
            ++this.totalCores;
        }
        this.synchroniseData();
    }

    public ManifestList buildSynchroniseManifest() {
        this.rebuildManifest();
        return this.manifestItems;
    }

    @Override
    public void synchroniseData() {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            PacketNetworks.DataResponse packet = new PacketNetworks.DataResponse(this.buildSynchroniseData());
            Networking.CHANNEL.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    @Override
    public void synchroniseHiveInfo() {
        EntityPlayer player = this.getPlayer();
        if (player != null) {
            PacketNetworks.HiveResponse packet = new PacketNetworks.HiveResponse(this.buildHiveMembershipData());
            Networking.CHANNEL.sendTo((IMessage)packet, (EntityPlayerMP)player);
        }
    }

    public HiveMembershipInfo buildHiveMembershipData() {
        return DataHelper.getHiveMembershipInfo(this.uuid);
    }

    @Override
    public boolean isHiveMember() {
        return DataHelper.isHiveMember(this.uuid);
    }

    @Override
    public List<ServerNetwork> getContainedNetworks() {
        return FAKE_MEMBERS;
    }

    @Override
    public void clearTiles() {
        this.tiles.clear();
    }

    @Override
    public ServerNetwork getOwnerNetwork() {
        return this;
    }

    @Override
    @Nullable
    public HiveNetwork getHiveNetwork() {
        World world = this.getWorld();
        if (DataHelper.isHiveMember(this.uuid)) {
            return DataHelper.getHiveNetwork(this.uuid);
        }
        return null;
    }

    @Override
    public void rebuildManifest() {
        this.manifestItems.clear();
        Map<Integer, List<ManifestUtils.ItemEntry>> preManifest = ManifestUtils.buildItemEntryList(this);
        List<ManifestUtils.CollatedEntry> manifestList = ManifestUtils.parsePreManifest(preManifest, this);
        this.manifestItems.addAll(manifestList);
    }

    @Override
    public TileListIterable getManifestTileEntities() {
        return TileUtils.filterAssignableClass(this.tiles, IManifestTileEntity.class);
    }

    @Override
    public SynchroniseInfo buildSynchroniseData() {
        SynchroniseInfo info = new SynchroniseInfo();
        info.totalResonators = this.getTotalResonators();
        info.totalCores = this.getTotalCores();
        return info;
    }

    public int distanceSq(BlockPos pos1, BlockPos pos2) {
        int d1 = pos1.func_177958_n() - pos2.func_177958_n();
        int d2 = pos1.func_177956_o() - pos2.func_177956_o();
        int d3 = pos1.func_177952_p() - pos2.func_177952_p();
        return Math.abs(d1 * d1 + d2 * d2 + d3 * d3);
    }

    public int distanceSqNoVertical(BlockPos pos1, BlockPos pos2) {
        int d1 = pos1.func_177958_n() - pos2.func_177958_n();
        int d2 = pos2.func_177952_p() - pos2.func_177952_p();
        return Math.abs(d1 * d1 + d2 * d2);
    }

    public boolean inRange(BlockPos pos1, BlockPos pos2) {
        int maxDistance = this.getMaxDistance();
        int distance = this.distanceSq(pos1, pos2);
        return distance < maxDistance;
    }
}

