/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.data;

import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.WorldSavedData;

public class NetworkSaveData
extends WorldSavedData {
    public static final String ID = "Archane-Archives-Network";
    private Map<UUID, ServerNetwork> arcaneArchivesNetworks = new HashMap<UUID, ServerNetwork>();

    public NetworkSaveData(String id) {
        super(id);
    }

    public NetworkSaveData() {
        super(ID);
    }

    public void clearServerMap() {
        this.arcaneArchivesNetworks.clear();
    }

    public Collection<ServerNetwork> getAllNetworks() {
        return this.arcaneArchivesNetworks.values();
    }

    @Nullable
    public ServerNetwork getNetwork(@Nullable UUID playerID) {
        if (playerID == null || playerID == DataHelper.INVALID) {
            return null;
        }
        if (!this.arcaneArchivesNetworks.containsKey(playerID)) {
            this.arcaneArchivesNetworks.put(playerID, new ServerNetwork(playerID));
            this.func_76185_a();
        }
        return this.arcaneArchivesNetworks.get(playerID);
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        NBTTagList networkData = tagCompound.func_150295_c("networkData", 10);
        for (int i = 0; i < networkData.func_74745_c(); ++i) {
            NBTTagCompound data = networkData.func_150305_b(i);
            ServerNetwork network = ServerNetwork.fromNBT(data);
            this.arcaneArchivesNetworks.put(network.getUuid(), network);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList networkData = new NBTTagList();
        for (ServerNetwork network : this.arcaneArchivesNetworks.values()) {
            networkData.func_74742_a((NBTBase)network.writeToSave());
        }
        tagCompound.func_74782_a("networkData", (NBTBase)networkData);
        return tagCompound;
    }
}

