/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.commands;

import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.HiveNetwork;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketDebug;
import com.aranaira.arcanearchives.tileentities.interfaces.IManifestTileEntity;
import com.aranaira.arcanearchives.types.IteRef;
import com.aranaira.arcanearchives.types.iterators.TileListIterable;
import com.aranaira.arcanearchives.types.lists.ITileList;
import com.aranaira.arcanearchives.util.TileUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandTiles
extends CommandBase {
    public String func_71517_b() {
        return "tiles";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/tiles | /tiles manifest | /tiles hive | /tiles mine | /tiles valid";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("tiles");
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayer) {
            ITileList tiles;
            EntityPlayer player = (EntityPlayer)sender;
            World world = player.field_70170_p;
            ServerNetwork network = DataHelper.getServerNetwork(player.func_110124_au());
            if (network == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("Sorry, can't find a network for you?"));
                return;
            }
            HiveNetwork hive = network.getHiveNetwork();
            if (args.length == 0) {
                player.func_145747_a((ITextComponent)new TextComponentString("Automatically deciding what tiles to highlight."));
                if (network.isHiveMember()) {
                    player.func_145747_a((ITextComponent)new TextComponentString("You're part of a hive! Fetching every tile..."));
                    tiles = hive.getTiles();
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString("You're not part of a hive! Just fetching your tiles."));
                    tiles = network.getTiles();
                }
            } else {
                switch (args[0].toLowerCase()) {
                    case "hive": {
                        if (!network.isHiveMember() || hive == null) {
                            player.func_145747_a((ITextComponent)new TextComponentString("You're not part of a hive!"));
                            return;
                        }
                        tiles = hive.getTiles();
                        break;
                    }
                    case "mine": {
                        tiles = network.getTiles();
                        break;
                    }
                    default: {
                        tiles = !network.isHiveMember() || hive == null ? network.getTiles() : hive.getTiles();
                    }
                }
            }
            Int2ObjectOpenHashMap positions = new Int2ObjectOpenHashMap();
            TileListIterable iterable = null;
            if (args.length > 0 && args[0].toLowerCase().equals("valid")) {
                player.func_145747_a((ITextComponent)new TextComponentString("Filtering to valid tiles only, unsure of how many tiles total there are."));
                iterable = TileUtils.filterValid(tiles);
            } else if (args.length > 0 && args[0].toLowerCase().equals("manifest")) {
                player.func_145747_a((ITextComponent)new TextComponentString("Filtering to manifest tiles only, unsure of how many tiles total there are."));
                iterable = TileUtils.filterAssignableClass(tiles, IManifestTileEntity.class);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("There are " + tiles.getSize() + " in your network."));
                iterable = tiles.iterable();
            }
            int i = 0;
            for (IteRef ref : iterable) {
                String result;
                ++i;
                if (ref == null) {
                    result = "Tile #" + i + " is null!";
                } else {
                    result = "Tile #" + i + " has UUID " + ref.uuid.toString() + " of " + ref.clazz.toString().replace("com.aranaira.arcanearchives.tileentities.", "") + " in dim: " + ref.dimension + "@" + String.format("%d,%d,%d", ref.pos.func_177958_n(), ref.pos.func_177956_o(), ref.pos.func_177952_p());
                    ((List)positions.computeIfAbsent((Object)ref.dimension, k -> new ArrayList())).add(ref.pos);
                    WorldServer w = DimensionManager.getWorld((int)ref.dimension);
                    result = w.func_175667_e(ref.pos) ? result + " and loaded" : result + " but not loaded";
                    if (ref.getTile() != null) {
                        result = result + " which resolves properly";
                        result = ref.getTile().func_145837_r() ? result + " but is invalid" : result + " and is valid";
                        result = ref.getTile().getNetworkId().equals(player.func_110124_au()) ? result + " and is part of your subnetwork" : result + " and is owned by someone else in your network";
                    } else {
                        result = result + " which does not resolve";
                    }
                }
                player.func_145747_a((ITextComponent)new TextComponentString(result));
            }
            for (Map.Entry entry : positions.entrySet()) {
                PacketDebug.TrackPositions packet = new PacketDebug.TrackPositions((List)entry.getValue(), (Integer)entry.getKey());
                Networking.CHANNEL.sendTo((IMessage)packet, (EntityPlayerMP)player);
            }
        }
    }
}

