/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.render;

import com.aranaira.arcanearchives.util.ColorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RenderUtils {
    public static final Vec3d ONE = new Vec3d(1.0, 1.0, 1.0);

    @SideOnly(value=Side.CLIENT)
    public static void drawRays(long worldTime, Vec3d adjustedPlayerPos, Set<Vec3d> target_pos) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179137_b((double)(-adjustedPlayerPos.field_72450_a), (double)(-adjustedPlayerPos.field_72448_b), (double)(-adjustedPlayerPos.field_72449_c));
        ColorUtils.Color c = ColorUtils.getColorFromTime(worldTime);
        GlStateManager.func_179131_c((float)c.red, (float)c.green, (float)c.blue, (float)c.alpha);
        GlStateManager.func_179132_a((boolean)false);
        Vec3d scale = ONE.func_186678_a(0.5);
        for (Vec3d vec : target_pos) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            GlStateManager.func_187441_d((float)((1.0f - RenderUtils.getLineWidthFromDistance(adjustedPlayerPos, vec, 10.0f, 70.0f)) * 10.0f));
            vec = vec.func_178787_e(scale);
            bufferBuilder.func_181662_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c).func_181666_a(c.red, c.green, c.blue, c.alpha).func_181675_d();
            bufferBuilder.func_181662_b(adjustedPlayerPos.field_72450_a, adjustedPlayerPos.field_72448_b + 1.0, adjustedPlayerPos.field_72449_c).func_181666_a(c.red, c.green, c.blue, c.alpha).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GlStateManager.func_179089_o();
        GlStateManager.func_179098_w();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawSegmentedLine(long worldTime, Color color, float width, Vec3d player_pos, ArrayList<Vec3d> verts) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179137_b((double)(-player_pos.field_72450_a), (double)(-player_pos.field_72448_b), (double)(-player_pos.field_72449_c));
        GlStateManager.func_179131_c((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(player_pos.field_72450_a, player_pos.field_72448_b + 1.0, player_pos.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        for (Vec3d vert : verts) {
            GlStateManager.func_187441_d((float)RenderUtils.getLineWidthFromDistance(player_pos, vert, 10.0f, 70.0f));
            bufferBuilder.func_181662_b(vert.field_72450_a, vert.field_72448_b, vert.field_72449_c).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private static float getLineWidthFromDistance(Vec3d first, Vec3d second, float minDistanceClamp, float maxDistanceClamp) {
        float dist = (float)first.func_72438_d(second);
        float normalized = MathHelper.func_76131_a((float)((dist - minDistanceClamp) / (maxDistanceClamp - minDistanceClamp)), (float)0.0f, (float)1.0f);
        return normalized * 0.7f + 0.3f;
    }

    public static void renderFullbrightBlockModel(World world, BlockPos pos, IBlockState state, boolean translateToOrigin) {
        GlStateManager.func_179094_E();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (translateToOrigin) {
            buffer.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        }
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher dispatcher = mc.func_175602_ab();
        BlockModelShapes shapes = dispatcher.func_175023_a();
        IBakedModel thisBlock = shapes.func_178125_b(state);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        long rand = MathHelper.func_180186_a((Vec3i)pos);
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (!state.func_177230_c().canRenderInLayer(state, layer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            dispatcher.func_175019_b().func_178267_a((IBlockAccess)world, thisBlock, state, pos, buffer, false);
        }
        ForgeHooksClient.setRenderLayer(null);
        if (translateToOrigin) {
            buffer.func_178969_c(0.0, 0.0, 0.0);
        }
        int colour = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)world, pos, 0);
        float[] argb = ColorUtils.getARGB(colour);
        float bright = 2.0f;
        buffer.func_178962_a(255, 255, 255, 255);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static BufferBuilder posVec3d(BufferBuilder bufferBuilder, Vec3d vec3d) {
        return bufferBuilder.func_181662_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
    }

    public static void createColoredVertex(BufferBuilder bufferBuilder, Vec3d pos, ColorUtils.Color color) {
        bufferBuilder.func_181662_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c).func_181666_a(color.red, color.green, color.blue, color.alpha).func_181675_d();
    }

    public static Vec3d getPlayerPosAdjusted(EntityPlayer e, float partialTicks) {
        double iPX = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks;
        double iPY = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)partialTicks;
        double iPZ = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks;
        return new Vec3d(iPX, iPY, iPZ);
    }
}

