/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.render;

import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.tileentities.RadiantTankTileEntity;
import com.aranaira.arcanearchives.util.ColorUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RadiantTankTESR
extends TileEntitySpecialRenderer<RadiantTankTileEntity> {
    private static Vec3d orig = new Vec3d(0.08, 0.05, 0.08);
    private static Vec3d other = new Vec3d(0.76, 0.0, 0.76);

    public void render(RadiantTankTileEntity te, double _x, double _y, double _z, float partialTicks, int destroyStage, float alpha) {
        if (te != null) {
            if (this.field_147501_a == null) {
                this.func_147497_a(TileEntityRendererDispatcher.field_147556_a);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179094_E();
            RenderHelper.func_74518_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            if (Minecraft.func_71379_u()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            RadiantTankTileEntity.VoidingFluidTank tank = te.getInventory();
            this.render(tank.getFluid(), tank.getCapacity(), te.func_174877_v());
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
        }
    }

    public void render(FluidStack fluidStack, int capacity, BlockPos pos) {
        if (fluidStack != null && fluidStack.amount > 0) {
            double vz1;
            double vy1;
            double u1;
            double x = RadiantTankTESR.orig.field_72450_a;
            double y = RadiantTankTESR.orig.field_72448_b;
            double z = RadiantTankTESR.orig.field_72449_c;
            double y2 = (double)fluidStack.amount / (double)capacity * 0.9;
            Minecraft mc = Minecraft.func_71410_x();
            TextureAtlasSprite top = mc.func_147117_R().getTextureExtry(fluidStack.getFluid().getStill(fluidStack).toString());
            TextureAtlasSprite side = mc.func_147117_R().getTextureExtry(fluidStack.getFluid().getFlowing(fluidStack).toString());
            if (side == null) {
                if (top != null) {
                    side = top;
                }
            } else if (top == null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                return;
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            int light = mc.field_71441_e.func_175626_b(pos, fluidStack.getFluid().getLuminosity());
            int color = fluidStack.getFluid().getColor(fluidStack);
            if (pos != BlockPos.field_177992_a) {
                float sx = (float)((double)pos.func_177958_n() - TileEntityRendererDispatcher.field_147554_b);
                float sy = (float)((double)pos.func_177956_o() - TileEntityRendererDispatcher.field_147555_c);
                float sz = (float)((double)pos.func_177952_p() - TileEntityRendererDispatcher.field_147552_d);
                GlStateManager.func_179109_b((float)sx, (float)sy, (float)sz);
            }
            buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179137_b((double)RadiantTankTESR.orig.field_72450_a, (double)RadiantTankTESR.orig.field_72448_b, (double)RadiantTankTESR.orig.field_72449_c);
            ColorUtils.ColourLight colour = ColorUtils.parseColour(color, light);
            double size = 16.0;
            double width = RadiantTankTESR.other.field_72450_a - RadiantTankTESR.orig.field_72450_a;
            double height = y2 - RadiantTankTESR.orig.field_72448_b;
            double length = RadiantTankTESR.other.field_72450_a - RadiantTankTESR.orig.field_72449_c;
            double x2 = RadiantTankTESR.other.field_72450_a;
            double z2 = RadiantTankTESR.other.field_72449_c;
            double u = RadiantTankTESR.orig.field_72450_a % 1.0;
            for (u1 = u + width; u1 > 1.0; u1 -= 1.0) {
            }
            double vy = RadiantTankTESR.orig.field_72448_b % 1.0;
            for (vy1 = vy + height; vy1 > 1.0; vy1 -= 1.0) {
            }
            double vz = RadiantTankTESR.orig.field_72449_c % 1.0;
            for (vz1 = vz + length; vz1 > 1.0; vz1 -= 1.0) {
            }
            double minU = top.func_94214_a(u * size);
            double maxU = top.func_94214_a(u1 * size);
            double minV = top.func_94207_b(vz * size);
            double maxV = top.func_94207_b(vz1 * size);
            buffer.func_181662_b(x, y, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x, y, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            minU = side.func_94214_a(u1 * size);
            maxU = side.func_94214_a(u * size);
            minV = side.func_94207_b(vy * size);
            maxV = side.func_94207_b(vy1 * size);
            buffer.func_181662_b(x, y, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x, y2, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y2, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            minU = side.func_94214_a(vz1 * size);
            maxU = side.func_94214_a(vz * size);
            minV = side.func_94207_b(vy * size);
            maxV = side.func_94207_b(vy1 * size);
            buffer.func_181662_b(x, y, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x, y, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x, y2, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x, y2, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            minU = side.func_94214_a(u1 * size);
            maxU = side.func_94214_a(u * size);
            minV = side.func_94207_b(vy * size);
            maxV = side.func_94207_b(vy1 * size);
            buffer.func_181662_b(x, y, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y2, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x, y2, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            minU = side.func_94214_a(vz1 * size);
            maxU = side.func_94214_a(vz * size);
            minV = side.func_94207_b(vy * size);
            maxV = side.func_94207_b(vy1 * size);
            buffer.func_181662_b(x2, y, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y2, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y2, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            minU = top.func_94214_a(u * size);
            maxU = top.func_94214_a(u1 * size);
            minV = top.func_94207_b(vz * size);
            maxV = top.func_94207_b(vz1 * size);
            buffer.func_181662_b(x, y2, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x, y2, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(minU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y2, z2).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, maxV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            buffer.func_181662_b(x2, y2, z).func_181669_b(colour.red, colour.green, colour.blue, colour.alpha).func_187315_a(maxU, minV).func_187314_a(colour.light1, colour.light2).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void render(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() == BlockRegistry.RADIANT_TANK.getItemBlock()) {
            if (this.field_147501_a == null) {
                this.func_147497_a(TileEntityRendererDispatcher.field_147556_a);
            }
            NBTTagCompound tag = stack.func_77978_p();
            FluidHandlerItemStack handler = (FluidHandlerItemStack)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            int maximumCapacity = 16000;
            if (tag.func_74764_b("maximum_capacity")) {
                maximumCapacity = tag.func_74762_e("maximum_capacity");
            }
            if (handler != null) {
                FluidStack fluid = handler.getFluid();
                boolean lighting = GL11.glIsEnabled((int)2896);
                if (!lighting) {
                    this.render(fluid, maximumCapacity, BlockPos.field_177992_a);
                } else {
                    GlStateManager.func_179140_f();
                    this.render(fluid, maximumCapacity, BlockPos.field_177992_a);
                    GlStateManager.func_179145_e();
                }
            }
        }
    }
}

