/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.render;

import com.aranaira.arcanearchives.client.render.RenderUtils;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import com.aranaira.arcanearchives.util.MathUtils;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="arcanearchives", value={Side.CLIENT})
public class LineHandler {
    public static boolean mIsDrawingLine;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void renderOverlay(RenderWorldLastEvent event) {
        Set<Vec3d> positions = ManifestTrackingUtils.getPositions(Minecraft.func_71410_x().field_71439_g.field_71093_bK);
        if (!positions.isEmpty()) {
            RenderUtils.drawRays(Minecraft.func_71410_x().field_71439_g.field_70170_p.func_82737_E(), RenderUtils.getPlayerPosAdjusted((EntityPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks()), (Set<Vec3d>)ImmutableSet.copyOf(positions));
        }
    }

    public static void addLine(Vec3d line, int dimension) {
        Set<Vec3d> positions = ManifestTrackingUtils.getPositions(dimension);
        positions.add(line);
    }

    public static void addLine(BlockPos pos, int dimension) {
        LineHandler.addLine(new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), dimension);
    }

    public static void addLines(List<BlockPos> positions, int dimension) {
        positions.forEach(k -> LineHandler.addLine(k, dimension));
    }

    public static void removeLine(BlockPos pos, int dimension) {
        Vec3d bpos = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        LineHandler.removeLine(bpos, dimension);
    }

    public static void removeLine(Vec3d line, int dimension) {
        Set<Vec3d> positions = ManifestTrackingUtils.getPositions(dimension);
        positions.remove(line);
    }

    public static void checkClear(int dimension) {
        if (ManifestTrackingUtils.getPositions(dimension).isEmpty()) {
            ManifestTrackingUtils.clear();
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        mIsDrawingLine = false;
    }

    public static void clearChests(int dimension) {
        Set<Vec3d> positions = ManifestTrackingUtils.getPositions(dimension);
        for (Vec3d pos : positions) {
            ManifestTrackingUtils.remove(dimension, MathUtils.vec3dToLong(pos));
        }
        positions.clear();
    }
}

