/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.gui.framework;

import com.aranaira.arcanearchives.client.gui.framework.IScrollableContainer;
import com.aranaira.arcanearchives.util.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class ScrollEventManager {
    private int currentIncrement;
    private int numSteps;
    private int stepsPerPage = 1;
    private List<IScrollableContainer> listeners = new ArrayList<IScrollableContainer>();

    public void registerListener(IScrollableContainer listener) {
        listener.registerScrollEventManager(this);
        this.listeners.add(listener);
    }

    public void unregisterListener(IScrollableContainer listener) {
        this.listeners.remove(listener);
    }

    public void setScrollPercent(float scrollPercent) {
        if (this.numSteps > 0) {
            float effectiveScrollPercent = Math.max(0.0f, Math.min(1.0f, scrollPercent));
            this.currentIncrement = Math.round(effectiveScrollPercent * (float)this.numSteps);
            for (IScrollableContainer scrollableContainer : this.listeners) {
                int yOffset = Math.round(effectiveScrollPercent * (float)scrollableContainer.getMaxYOffset());
                scrollableContainer.getScrollable().forEach(scrollableElement -> scrollableElement.updateY(yOffset));
            }
        }
    }

    public void setStepsPerPage(int stepsPerPage) {
        this.stepsPerPage = stepsPerPage;
    }

    public void pageUp() {
        this.currentIncrement = Math.max(0, this.currentIncrement - this.stepsPerPage);
        this.updateYOffsets();
    }

    public void pageDown() {
        this.currentIncrement = Math.min(this.numSteps, this.currentIncrement + this.stepsPerPage);
        this.updateYOffsets();
    }

    public void arrowDown() {
        if (this.currentIncrement < this.numSteps) {
            ++this.currentIncrement;
            this.updateYOffsets();
        }
    }

    public void arrowUp() {
        if (this.currentIncrement > 0) {
            --this.currentIncrement;
            this.updateYOffsets();
        }
    }

    public void setNumSteps(int numSteps) {
        this.numSteps = Math.max(0, numSteps);
        this.updateYOffsets();
    }

    private void updateYOffsets() {
        if (this.numSteps > 0) {
            for (IScrollableContainer scrollableContainer : this.listeners) {
                int stepSize = MathUtils.intDivisionCeiling(scrollableContainer.getMaxYOffset(), this.numSteps);
                int yOffset = Math.min(scrollableContainer.getMaxYOffset(), stepSize * this.currentIncrement);
                scrollableContainer.getScrollable().forEach(scrollableElement -> scrollableElement.updateY(yOffset));
            }
        }
    }
}

