/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.gui;

import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.inventory.ContainerRadiantCraftingTable;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketRadiantCrafting;
import com.aranaira.arcanearchives.util.ColorUtils;
import com.aranaira.arcanearchives.util.KeyboardUtil;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GUIRadiantCraftingTable
extends GuiContainer {
    private static final ResourceLocation GUITextures = new ResourceLocation("arcanearchives:textures/gui/radiantcraftingtable.png");
    private static final ResourceLocation GUITexturesSimple = new ResourceLocation("arcanearchives:textures/gui/simple/radiantcraftingtable.png");
    private ContainerRadiantCraftingTable container;
    private List<ItemStack> tracked;
    private int mouseOverX = 0;
    private int mouseOverY = 0;

    public GUIRadiantCraftingTable(EntityPlayer player, ContainerRadiantCraftingTable container) {
        super((Container)container);
        this.field_146999_f = 206;
        this.field_147000_g = 203;
        this.tracked = ManifestTrackingUtils.get(player.field_71093_bK, container.pos);
        this.container = container;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.mouseOverX = mouseX;
        this.mouseOverY = mouseY;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        if (ConfigHandler.UsePrettyGUIs) {
            this.field_146297_k.func_110434_K().func_110577_a(GUITextures);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GUITexturesSimple);
        }
        GUIRadiantCraftingTable.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)256, (int)256, (float)256.0f, (float)256.0f);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        if (slotIn instanceof ContainerRadiantCraftingTable.SlotIRecipe) {
            ContainerRadiantCraftingTable.SlotIRecipe slot = (ContainerRadiantCraftingTable.SlotIRecipe)slotIn;
            boolean shiftDown = KeyboardUtil.isShiftDown();
            if (slot.func_75216_d() && shiftDown) {
                PacketRadiantCrafting.UnsetRecipe packet = new PacketRadiantCrafting.UnsetRecipe(this.container.tile.func_174877_v(), this.container.tile.dimension, slot.getRecipe());
                Networking.CHANNEL.sendToServer((IMessage)packet);
                return;
            }
            if (!slot.func_75216_d() && shiftDown) {
                IRecipe toUse = this.container.getLastCraftedRecipe();
                PacketRadiantCrafting.SetRecipe packet = new PacketRadiantCrafting.SetRecipe(this.container.tile.func_174877_v(), this.container.tile.dimension, slot.getRecipe(), toUse);
                Networking.CHANNEL.sendToServer((IMessage)packet);
                return;
            }
            if (!slot.func_75216_d() && !shiftDown) {
                IRecipe toUse = this.container.getCurrentRecipe();
                PacketRadiantCrafting.SetRecipe packet = new PacketRadiantCrafting.SetRecipe(this.container.tile.func_174877_v(), this.container.tile.dimension, slot.getRecipe(), toUse);
                Networking.CHANNEL.sendToServer((IMessage)packet);
                return;
            }
            if (slot.func_75216_d() && !shiftDown) {
                PacketRadiantCrafting.TryCraftRecipe packet = new PacketRadiantCrafting.TryCraftRecipe(this.container.tile.func_174877_v(), this.container.tile.dimension, slot.getRecipe());
                Networking.CHANNEL.sendToServer((IMessage)packet);
            }
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    public void func_146977_a(Slot slot) {
        ItemStack stack = slot.func_75211_c();
        if (!stack.func_190926_b() && !(slot instanceof ContainerRadiantCraftingTable.SlotIRecipe) && this.tracked != null && !this.tracked.isEmpty() && ManifestTrackingUtils.matches(stack, this.tracked)) {
            GlStateManager.func_179097_i();
            long worldTime = this.field_146297_k.field_71439_g.field_70170_p.func_72820_D();
            ColorUtils.Color c = ColorUtils.getColorFromTime(worldTime);
            GuiContainer.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)c.toInteger());
            GlStateManager.func_179126_j();
        }
        if (slot instanceof ContainerRadiantCraftingTable.SlotIRecipe && this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, this.mouseOverX, this.mouseOverY)) {
            if (!slot.func_75216_d()) {
                if (stack.func_190926_b()) {
                    IRecipe recipe;
                    int i = slot.field_75223_e;
                    int j = slot.field_75221_f;
                    IRecipe iRecipe = recipe = KeyboardUtil.isShiftDown() ? this.container.getLastCraftedRecipe() : this.container.getCurrentRecipe();
                    if (recipe != null) {
                        ItemStack result = recipe.func_77571_b();
                        GUIRadiantCraftingTable.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
                        GlStateManager.func_179126_j();
                        this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, result, i, j);
                        this.field_146296_j.func_180453_a(this.field_146289_q, result, i, j, null);
                    }
                }
            } else {
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    return;
                }
                if (!this.container.tile.canCraftRecipe((EntityPlayer)this.field_146297_k.field_71439_g, ((ContainerRadiantCraftingTable.SlotIRecipe)slot).getRecipe())) {
                    GlStateManager.func_179097_i();
                    ColorUtils.Color c = new ColorUtils.Color(0.7411765f, 0.10980392f, 0.10980392f, 1.0f);
                    GuiContainer.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)c.toInteger());
                    GlStateManager.func_179126_j();
                }
            }
        }
        super.func_146977_a(slot);
    }
}

