/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.gui;

import com.aranaira.arcanearchives.client.gui.controls.InvisibleButton;
import com.aranaira.arcanearchives.client.gui.controls.RightClickTextField;
import com.aranaira.arcanearchives.client.render.RenderItemExtended;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.inventory.ContainerRadiantChest;
import com.aranaira.arcanearchives.inventory.slots.SlotExtended;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketRadiantChest;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.interfaces.IBrazierRouting;
import com.aranaira.arcanearchives.util.ColorUtils;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import vazkii.quark.api.IChestButtonCallback;
import vazkii.quark.api.IItemSearchBar;

@Optional.InterfaceList(value={@Optional.Interface(modid="quark", iface="vazkii.quark.api.IChestButtonCallback", striprefs=true), @Optional.Interface(modid="quark", iface="vazkii.quark.api.IItemSearchBar", striprefs=true)})
public class GUIRadiantChest
extends GuiContainer
implements GuiPageButtonList.GuiResponder,
IChestButtonCallback,
IItemSearchBar {
    private static final ResourceLocation GUITextures = new ResourceLocation("arcanearchives:textures/gui/radiantchest.png");
    private static final ResourceLocation GUITexturesSimple = new ResourceLocation("arcanearchives:textures/gui/simple/radiantchest.png");
    private final int MAIN_W = 192;
    private final int MAIN_H = 253;
    private final int CHECK_X = 234;
    private final int CHECK_Y = 0;
    private final int CHECK_S = 6;
    private final int SLASH_X = 240;
    private final int SLASH_Y = 0;
    private final int SLASH_S = 16;
    private final int ROUTING_TOOLTIP_X = 159;
    private final int ROUTING_TOOLTIP_Y = 234;
    private final int ROUTING_TOOLTIP_W = 33;
    private final int ROUTING_TOOLTIP_H = 16;
    private final int ImageScale = 256;
    private Slot hoveredSlot;
    private Slot clickedSlot;
    private boolean isRightMouseClick;
    private ItemStack draggedStack = ItemStack.field_190927_a;
    private int touchUpX;
    private int touchUpY;
    private Slot returningStackDestSlot;
    private long returningStackTime;
    private ItemStack returningStack = ItemStack.field_190927_a;
    private Slot currentDragTargetSlot;
    private long dragItemDropDelay;
    private int dragSplittingLimit;
    private int dragSplittingButton;
    private boolean ignoreMouseUp;
    private int dragSplittingRemnant;
    private long lastClickTime;
    private Slot lastClickSlot;
    private int lastClickButton;
    private boolean doubleClick;
    private ItemStack shiftClickedSlot = ItemStack.field_190927_a;
    private RadiantChestTileEntity tile;
    private InventoryPlayer playerinventory;
    private List<ItemStack> tracked;
    private int dimension;
    private BlockPos pos;
    private RightClickTextField nameBox;
    private ContainerRadiantChest container;
    private int mNameTextLeftOffset = 53;
    private int mNameTextTopOffset = 238;
    private int mNameTextWidth = 88;
    private int mNameTextHeight = 10;
    private GuiButton toggleButton;
    private String lastValue = null;

    public GUIRadiantChest(ContainerRadiantChest container, InventoryPlayer playerinventory) {
        super((Container)container);
        this.container = container;
        this.playerinventory = playerinventory;
        this.tile = container.getTile();
        this.field_146999_f = 192;
        this.field_147000_g = 253;
        this.ignoreMouseUp = true;
        this.dimension = this.tile.dimension;
        this.pos = this.tile.func_174877_v();
        this.tracked = ManifestTrackingUtils.get(this.dimension, this.pos);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.nameBox = new RightClickTextField(1, this.field_146289_q, this.field_147003_i + this.mNameTextLeftOffset, this.field_147009_r + this.mNameTextTopOffset, this.mNameTextWidth, this.mNameTextHeight);
        this.nameBox.func_146180_a(this.container.getTile().getChestName());
        this.nameBox.func_175207_a(this);
        this.nameBox.func_146185_a(false);
        this.field_146292_n.clear();
        this.toggleButton = new InvisibleButton(0, this.field_147003_i + 161, this.field_147009_r + 236, 12, 12, "");
        this.func_189646_b(this.toggleButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 0 && this.tile.getUuid() != null && this.field_146297_k.field_71439_g.func_110124_au() != null) {
            PacketRadiantChest.ToggleBrazier packet = new PacketRadiantChest.ToggleBrazier(this.field_146297_k.field_71439_g.func_110124_au(), this.tile.getUuid());
            Networking.CHANNEL.sendToServer((IMessage)packet);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (ConfigHandler.UsePrettyGUIs) {
            this.field_146297_k.func_110434_K().func_110577_a(GUITextures);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GUITexturesSimple);
        }
        GUIRadiantChest.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)192, (int)253, (float)256.0f, (float)256.0f);
        if (this.container.getTile().getRoutingType() == IBrazierRouting.BrazierRoutingType.NO_NEW_STACKS) {
            this.func_73729_b(this.field_147003_i + 164, this.field_147009_r + 239, 234, 0, 6, 6);
            this.func_73729_b(this.field_147003_i + 176, this.field_147009_r + 234, 240, 0, 16, 16);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ItemStack itemstack;
        int k;
        this.func_146276_q_();
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_146976_a(partialTicks, mouseX, mouseY);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        for (k = 0; k < this.field_146292_n.size(); ++k) {
            ((GuiButton)this.field_146292_n.get(k)).func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        for (int l = 0; l < this.field_146293_o.size(); ++l) {
            ((GuiLabel)this.field_146293_o.get(l)).func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)i, (float)j, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        this.hoveredSlot = null;
        k = 240;
        int l = 240;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = 0; i1 < this.field_147002_h.field_75151_b.size(); ++i1) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i1);
            if (slot.func_111238_b()) {
                this.func_146977_a(slot);
            }
            if (!this.isMouseOverSlot(slot, mouseX, mouseY) || !slot.func_111238_b()) continue;
            this.hoveredSlot = slot;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int j1 = slot.field_75223_e;
            int k1 = slot.field_75221_f;
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        RenderHelper.func_74518_a();
        this.func_146979_b(mouseX, mouseY);
        RenderHelper.func_74520_c();
        MinecraftForge.EVENT_BUS.post((Event)new GuiContainerEvent.DrawForeground((GuiContainer)this, mouseX, mouseY));
        InventoryPlayer inventoryplayer = this.field_146297_k.field_71439_g.field_71071_by;
        ItemStack itemStack = itemstack = this.draggedStack.func_190926_b() ? inventoryplayer.func_70445_o() : this.draggedStack;
        if (!itemstack.func_190926_b()) {
            int j2 = 8;
            int k2 = this.draggedStack.func_190926_b() ? 8 : 16;
            String s = null;
            if (!this.draggedStack.func_190926_b() && this.isRightMouseClick) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(MathHelper.func_76123_f((float)((float)itemstack.func_190916_E() / 2.0f)));
            } else if (this.field_147007_t && this.field_147008_s.size() > 1) {
                itemstack = itemstack.func_77946_l();
                itemstack.func_190920_e(this.dragSplittingRemnant);
                if (itemstack.func_190926_b()) {
                    s = "" + TextFormatting.YELLOW + "0";
                }
            }
            this.drawItemStack(itemstack, mouseX - i - 8, mouseY - j - k2, s);
        }
        if (!this.returningStack.func_190926_b()) {
            float f = (float)(Minecraft.func_71386_F() - this.returningStackTime) / 100.0f;
            if (f >= 1.0f) {
                f = 1.0f;
                this.returningStack = ItemStack.field_190927_a;
            }
            int l2 = this.returningStackDestSlot.field_75223_e - this.touchUpX;
            int i3 = this.returningStackDestSlot.field_75221_f - this.touchUpY;
            int l1 = this.touchUpX + (int)((float)l2 * f);
            int i2 = this.touchUpY + (int)((float)i3 * f);
            this.drawItemStack(this.returningStack, l1, i2, null);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        this.nameBox.func_146194_f();
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (mouseY >= this.field_147009_r + 234 && mouseY <= this.field_147009_r + 234 + 16 && mouseX >= this.field_147003_i + 159 && mouseX <= this.field_147003_i + 159 + 33) {
            ArrayList<String> tooltip = new ArrayList<String>();
            if (this.container.getTile().getRoutingType() == IBrazierRouting.BrazierRoutingType.NO_NEW_STACKS) {
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.radiantchest.routingmode.nonewitems1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.radiantchest.routingmode.nonewitems2", (Object[])new Object[0]));
            } else {
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.radiantchest.routingmode.any1", (Object[])new Object[0]));
                tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.radiantchest.routingmode.any2", (Object[])new Object[0]));
            }
            this.func_146283_a(tooltip, mouseX, mouseY);
            return;
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.hoveredSlot != null && this.hoveredSlot.func_75216_d()) {
            this.func_146285_a(this.hoveredSlot.func_75211_c(), mouseX, mouseY);
        }
    }

    private void drawItemStack(ItemStack stack, int x, int y, String altText) {
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        RenderItemExtended.INSTANCE.setZLevel(this.field_146296_j.field_77023_b);
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_146289_q;
        }
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(font, stack, x, y - (this.draggedStack.func_190926_b() ? 0 : 8), altText);
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
        RenderItemExtended.INSTANCE.setZLevel(this.field_146296_j.field_77023_b);
    }

    public void func_146977_a(Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        ItemStack stack = slotIn.func_75211_c();
        if (!stack.func_190926_b() && this.tracked != null && !this.tracked.isEmpty() && ManifestTrackingUtils.matches(stack, this.tracked)) {
            GlStateManager.func_179097_i();
            long worldTime = this.field_146297_k.field_71439_g.field_70170_p.func_72820_D();
            ColorUtils.Color c = ColorUtils.getColorFromTime(worldTime);
            GuiContainer.func_73734_a((int)slotIn.field_75223_e, (int)slotIn.field_75221_f, (int)(slotIn.field_75223_e + 16), (int)(slotIn.field_75221_f + 16), (int)c.toInteger());
            GlStateManager.func_179126_j();
        }
        int i = slotIn.field_75223_e;
        int j = slotIn.field_75221_f;
        ItemStack itemstack = slotIn.func_75211_c();
        boolean flag = false;
        boolean flag1 = slotIn == this.clickedSlot && !this.draggedStack.func_190926_b() && !this.isRightMouseClick;
        ItemStack itemstack1 = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        String s = null;
        if (slotIn == this.clickedSlot && !this.draggedStack.func_190926_b() && this.isRightMouseClick && !itemstack.func_190926_b()) {
            itemstack = itemstack.func_77946_l();
            itemstack.func_190920_e(itemstack.func_190916_E() / 2);
        } else if (this.field_147007_t && this.field_147008_s.contains(slotIn) && !itemstack1.func_190926_b()) {
            if (this.field_147008_s.size() == 1) {
                return;
            }
            if (ContainerRadiantChest.canAddItemToSlot(slotIn, itemstack1, true) && this.field_147002_h.func_94531_b(slotIn)) {
                itemstack = itemstack1.func_77946_l();
                flag = true;
                Container.func_94525_a((Set)this.field_147008_s, (int)this.dragSplittingLimit, (ItemStack)itemstack, (int)(slotIn.func_75211_c().func_190926_b() ? 0 : slotIn.func_75211_c().func_190916_E()));
                int k = slotIn.func_178170_b(itemstack);
                if (itemstack.func_190916_E() > k) {
                    s = TextFormatting.YELLOW.toString() + k;
                    itemstack.func_190920_e(k);
                }
            } else {
                this.field_147008_s.remove(slotIn);
                this.updateDragSplitting();
            }
        }
        this.field_73735_i = 100.0f;
        this.field_146296_j.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null) {
            GlStateManager.func_179140_f();
            this.field_146297_k.func_110434_K().func_110577_a(slotIn.getBackgroundLocation());
            this.func_175175_a(i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        if (!flag1) {
            if (flag) {
                GUIRadiantChest.func_73734_a((int)i, (int)j, (int)(i + 16), (int)(j + 16), (int)-2130706433);
            }
            GlStateManager.func_179126_j();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, itemstack, i, j);
            RenderItemExtended.INSTANCE.setZLevel(this.field_146296_j.field_77023_b);
            if (slotIn instanceof SlotExtended) {
                RenderItemExtended.INSTANCE.renderItemOverlayIntoGUI(this.field_146289_q, itemstack, i, j, s);
            } else {
                this.field_146296_j.func_180453_a(this.field_146289_q, itemstack, i, j, s);
            }
        }
        this.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        RenderItemExtended.INSTANCE.setZLevel(this.field_146296_j.field_77023_b);
    }

    private void updateDragSplitting() {
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (!itemstack.func_190926_b() && this.field_147007_t) {
            if (this.dragSplittingLimit == 2) {
                this.dragSplittingRemnant = itemstack.func_77976_d();
            } else {
                this.dragSplittingRemnant = itemstack.func_190916_E();
                for (Slot slot : this.field_147008_s) {
                    ItemStack itemstack1 = itemstack.func_77946_l();
                    ItemStack itemstack2 = slot.func_75211_c();
                    int i = itemstack2.func_190926_b() ? 0 : itemstack2.func_190916_E();
                    Container.func_94525_a((Set)this.field_147008_s, (int)this.dragSplittingLimit, (ItemStack)itemstack1, (int)i);
                    int j = slot.func_178170_b(itemstack1);
                    if (itemstack1.func_190916_E() > j) {
                        itemstack1.func_190920_e(j);
                    }
                    this.dragSplittingRemnant -= itemstack1.func_190916_E() - i;
                }
            }
        }
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
            if (!this.isMouseOverSlot(slot, x, y) || !slot.func_111238_b()) continue;
            return slot;
        }
        return null;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.field_146290_a = guibutton = event.getButton();
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
            }
        }
        boolean flag = this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100);
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        long i = Minecraft.func_71386_F();
        this.doubleClick = this.lastClickSlot == slot && i - this.lastClickTime < 250L && this.lastClickButton == mouseButton;
        this.ignoreMouseUp = false;
        if (mouseButton == 0 || mouseButton == 1 || flag) {
            int j = this.field_147003_i;
            int k = this.field_147009_r;
            boolean flag1 = this.func_193983_c(mouseX, mouseY, j, k);
            if (slot != null) {
                flag1 = false;
            }
            int l = -1;
            if (slot != null) {
                l = slot.field_75222_d;
            }
            if (flag1) {
                l = -999;
            }
            if (this.field_146297_k.field_71474_y.field_85185_A && flag1 && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.field_146297_k.func_147108_a(null);
                return;
            }
            if (l != -1) {
                if (this.field_146297_k.field_71474_y.field_85185_A) {
                    if (slot != null && slot.func_75216_d()) {
                        this.clickedSlot = slot;
                        this.draggedStack = ItemStack.field_190927_a;
                        this.isRightMouseClick = mouseButton == 1;
                    } else {
                        this.clickedSlot = null;
                    }
                } else if (!this.field_147007_t) {
                    if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                        if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                            this.func_184098_a(slot, l, mouseButton, ClickType.CLONE);
                        } else {
                            boolean flag2 = l != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                            ClickType clicktype = ClickType.PICKUP;
                            if (flag2) {
                                this.shiftClickedSlot = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                                clicktype = ClickType.QUICK_MOVE;
                            } else if (l == -999) {
                                clicktype = ClickType.THROW;
                            }
                            this.func_184098_a(slot, l, mouseButton, clicktype);
                        }
                        this.ignoreMouseUp = true;
                    } else {
                        this.field_147007_t = true;
                        this.dragSplittingButton = mouseButton;
                        this.field_147008_s.clear();
                        if (mouseButton == 0) {
                            this.dragSplittingLimit = 0;
                        } else if (mouseButton == 1) {
                            this.dragSplittingLimit = 1;
                        } else if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(mouseButton - 100)) {
                            this.dragSplittingLimit = 2;
                        }
                    }
                }
            }
        }
        this.lastClickSlot = slot;
        this.lastClickTime = i;
        this.lastClickButton = mouseButton;
        this.nameBox.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        ItemStack itemstack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        if (this.clickedSlot != null && this.field_146297_k.field_71474_y.field_85185_A) {
            if (clickedMouseButton == 0 || clickedMouseButton == 1) {
                if (this.draggedStack.func_190926_b()) {
                    if (slot != this.clickedSlot && !this.clickedSlot.func_75211_c().func_190926_b()) {
                        this.draggedStack = this.clickedSlot.func_75211_c().func_77946_l();
                    }
                } else if (this.draggedStack.func_190916_E() > 1 && slot != null && ContainerRadiantChest.canAddItemToSlot(slot, this.draggedStack, false)) {
                    long i = Minecraft.func_71386_F();
                    if (this.currentDragTargetSlot == slot) {
                        if (i - this.dragItemDropDelay > 500L) {
                            this.func_184098_a(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.func_184098_a(slot, slot.field_75222_d, 1, ClickType.PICKUP);
                            this.func_184098_a(this.clickedSlot, this.clickedSlot.field_75222_d, 0, ClickType.PICKUP);
                            this.dragItemDropDelay = i + 750L;
                            this.draggedStack.func_190918_g(1);
                        }
                    } else {
                        this.currentDragTargetSlot = slot;
                        this.dragItemDropDelay = i;
                    }
                }
            }
        } else if (this.field_147007_t && slot != null && !itemstack.func_190926_b() && (itemstack.func_190916_E() > this.field_147008_s.size() || this.dragSplittingLimit == 2) && ContainerRadiantChest.canAddItemToSlot(slot, itemstack, true) && slot.func_75214_a(itemstack) && this.field_147002_h.func_94531_b(slot)) {
            this.field_147008_s.add(slot);
            this.updateDragSplitting();
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.field_146290_a != null && state == 0) {
            this.field_146290_a.func_146118_a(mouseX, mouseY);
            this.field_146290_a = null;
        }
        Slot slot = this.getSlotAtPosition(mouseX, mouseY);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        boolean flag = this.func_193983_c(mouseX, mouseY, i, j);
        if (slot != null) {
            flag = false;
        }
        int k = -1;
        if (slot != null) {
            k = slot.field_75222_d;
        }
        if (flag) {
            k = -999;
        }
        if (this.doubleClick && slot != null && state == 0 && this.field_147002_h.func_94530_a(ItemStack.field_190927_a, slot)) {
            if (GUIRadiantChest.func_146272_n()) {
                if (!this.shiftClickedSlot.func_190926_b()) {
                    for (Slot slot2 : this.field_147002_h.field_75151_b) {
                        if (slot2 == null || !slot2.func_82869_a((EntityPlayer)this.field_146297_k.field_71439_g) || !slot2.func_75216_d() || !slot2.isSameInventory(slot) || !ContainerRadiantChest.canAddItemToSlot(slot2, this.shiftClickedSlot, true)) continue;
                        this.func_184098_a(slot2, slot2.field_75222_d, state, ClickType.QUICK_MOVE);
                    }
                }
            } else {
                this.func_184098_a(slot, k, state, ClickType.PICKUP_ALL);
            }
            this.doubleClick = false;
            this.lastClickTime = 0L;
        } else {
            if (this.field_147007_t && this.dragSplittingButton != state) {
                this.field_147007_t = false;
                this.field_147008_s.clear();
                this.ignoreMouseUp = true;
                return;
            }
            if (this.ignoreMouseUp) {
                this.ignoreMouseUp = false;
                return;
            }
            if (this.clickedSlot != null && this.field_146297_k.field_71474_y.field_85185_A) {
                if (state == 0 || state == 1) {
                    if (this.draggedStack.func_190926_b() && slot != this.clickedSlot) {
                        this.draggedStack = this.clickedSlot.func_75211_c();
                    }
                    boolean flag2 = ContainerRadiantChest.canAddItemToSlot(slot, this.draggedStack, false);
                    if (k != -1 && !this.draggedStack.func_190926_b() && flag2) {
                        this.func_184098_a(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                        this.func_184098_a(slot, k, 0, ClickType.PICKUP);
                        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            this.returningStack = ItemStack.field_190927_a;
                        } else {
                            this.func_184098_a(this.clickedSlot, this.clickedSlot.field_75222_d, state, ClickType.PICKUP);
                            this.touchUpX = mouseX - i;
                            this.touchUpY = mouseY - j;
                            this.returningStackDestSlot = this.clickedSlot;
                            this.returningStack = this.draggedStack;
                            this.returningStackTime = Minecraft.func_71386_F();
                        }
                    } else if (!this.draggedStack.func_190926_b()) {
                        this.touchUpX = mouseX - i;
                        this.touchUpY = mouseY - j;
                        this.returningStackDestSlot = this.clickedSlot;
                        this.returningStack = this.draggedStack;
                        this.returningStackTime = Minecraft.func_71386_F();
                    }
                    this.draggedStack = ItemStack.field_190927_a;
                    this.clickedSlot = null;
                }
            } else if (this.field_147007_t && !this.field_147008_s.isEmpty()) {
                this.func_184098_a(null, -999, Container.func_94534_d((int)0, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                for (Slot slot1 : this.field_147008_s) {
                    this.func_184098_a(slot1, slot1.field_75222_d, Container.func_94534_d((int)1, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
                }
                this.func_184098_a(null, -999, Container.func_94534_d((int)2, (int)this.dragSplittingLimit), ClickType.QUICK_CRAFT);
            } else if (!this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(state - 100)) {
                    this.func_184098_a(slot, k, state, ClickType.CLONE);
                } else {
                    boolean flag1;
                    boolean bl = flag1 = k != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                    if (flag1) {
                        this.shiftClickedSlot = slot != null && slot.func_75216_d() ? slot.func_75211_c().func_77946_l() : ItemStack.field_190927_a;
                    }
                    this.func_184098_a(slot, k, state, flag1 ? ClickType.QUICK_MOVE : ClickType.PICKUP);
                }
            }
        }
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            this.lastClickTime = 0L;
        }
        this.field_147007_t = false;
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.func_146978_c(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.nameBox.func_146206_l()) {
            this.nameBox.func_146201_a(typedChar, keyCode);
            return;
        }
        if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.func_146983_a(keyCode);
        if (this.hoveredSlot != null && this.hoveredSlot.func_75216_d()) {
            if (this.field_146297_k.field_71474_y.field_74322_I.isActiveAndMatches(keyCode)) {
                this.func_184098_a(this.hoveredSlot, this.hoveredSlot.field_75222_d, 0, ClickType.CLONE);
            } else if (this.field_146297_k.field_71474_y.field_74316_C.isActiveAndMatches(keyCode)) {
                this.func_184098_a(this.hoveredSlot, this.hoveredSlot.field_75222_d, GUIRadiantChest.func_146271_m() ? 1 : 0, ClickType.THROW);
            }
        }
    }

    protected boolean func_146983_a(int keyCode) {
        if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b() && this.hoveredSlot != null) {
            for (int i = 0; i < 9; ++i) {
                if (!this.field_146297_k.field_71474_y.field_151456_ac[i].isActiveAndMatches(keyCode)) continue;
                this.func_184098_a(this.hoveredSlot, this.hoveredSlot.field_75222_d, i, ClickType.SWAP);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        return this.hoveredSlot;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.tracked != null) {
            ManifestTrackingUtils.remove(this.dimension, this.pos);
        }
    }

    @Optional.Method(modid="quark")
    public boolean onAddChestButton(GuiButton button, int buttonType) {
        return true;
    }

    @Optional.Method(modid="quark")
    public void onSearchBarAdded(GuiTextField bar) {
        bar.field_146210_g = this.field_146295_m / 2 + 2;
        bar.field_146209_f = this.field_146294_l / 2 - bar.field_146218_h / 2;
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        if (this.lastValue != null && !this.lastValue.isEmpty() && value.isEmpty()) {
            PacketRadiantChest.UnsetName packet = new PacketRadiantChest.UnsetName(this.tile.func_174877_v(), this.tile.dimension);
            Networking.CHANNEL.sendToServer((IMessage)packet);
        } else if (this.lastValue == null || !this.lastValue.equals(value)) {
            PacketRadiantChest.SetName packet = new PacketRadiantChest.SetName(this.tile.func_174877_v(), value, this.tile.dimension);
            Networking.CHANNEL.sendToServer((IMessage)packet);
        }
        this.lastValue = value;
    }
}

