/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.client.gui;

import com.aranaira.arcanearchives.client.gui.controls.InvisibleButton;
import com.aranaira.arcanearchives.client.gui.controls.ManifestSearchField;
import com.aranaira.arcanearchives.client.gui.controls.ScrollBar;
import com.aranaira.arcanearchives.client.gui.framework.CustomCountSlot;
import com.aranaira.arcanearchives.client.gui.framework.LayeredGuiContainer;
import com.aranaira.arcanearchives.client.gui.framework.ScrollEventManager;
import com.aranaira.arcanearchives.client.render.LineHandler;
import com.aranaira.arcanearchives.config.ConfigHandler;
import com.aranaira.arcanearchives.data.ClientNetwork;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.integration.jei.JEIPlugin;
import com.aranaira.arcanearchives.inventory.ContainerManifest;
import com.aranaira.arcanearchives.types.lists.ManifestList;
import com.aranaira.arcanearchives.util.ColorUtils;
import com.aranaira.arcanearchives.util.ManifestTrackingUtils;
import com.aranaira.arcanearchives.util.ManifestUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketCloseWindow;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GUIManifest
extends LayeredGuiContainer
implements GuiPageButtonList.GuiResponder {
    private static final ResourceLocation GUIBaseTextures = new ResourceLocation("arcanearchives:textures/gui/manifest_base.png");
    private static final ResourceLocation GUIBaseTexturesSimple = new ResourceLocation("arcanearchives:textures/gui/simple/manifest_base.png");
    private static final int mGUIBaseTexturesSize = 256;
    private static final ResourceLocation GUIForegroundTextures = new ResourceLocation("arcanearchives:textures/gui/manifest_overlay.png");
    private static final ResourceLocation GUIForegroundTexturesSimple = new ResourceLocation("arcanearchives:textures/gui/simple/manifest_overlay.png");
    private static final float mGUIForegroundTexturesSize = 256.0f;
    private final EntityPlayer player;
    private ContainerManifest container;
    private ScrollEventManager scrollEventManager = new ScrollEventManager();
    private static final int mTextTopOffset = 13;
    private static final int mTextLeftOffset = 13;
    private static final int mTextWidth = 89;
    private static final int mTextHeight = 11;
    private static final int mEndTrackingLeftOffset = 48;
    private static final int mEndTrackingTopOffset = 200;
    private static final int mEndTrackingButtonWidth = 88;
    private static final int mEndTrackingButtonHeight = 12;
    private static final int mRefreshButtonLeftOffset = 178;
    private static final int mRefreshButtonTopOffset = 200;
    private static final int mRefreshButtonWidth = 14;
    private static final int mRefreshButtonHeight = 14;
    private static final int mConfigButtonLeftOffset = 158;
    private static final int mConfigButtonTopOffset = 200;
    private static final int mConfigButtonWidth = 14;
    private static final int mConfigButtonHeight = 14;
    private static final int mScrollBarTopOffset = 29;
    private static final int mScrollBarBottomOffset = 191;
    private static final int mScrollBarLeftOffset = 178;
    private static final int mSlotTextureLeftOffset = 224;
    private static final int mSlotTextureSize = 18;
    private static final int mAlphaQuantButtonLeftOffset = 242;
    private static final int mAlphaQuantButtonTopOffset = 28;
    private static final int mAlphaQuantButtonSize = 14;
    private static final int mAscDescButtonLeftOffset = 242;
    private static final int mAscDescButtonTopOffset = 56;
    private static final int mAscDescButtonSize = 14;
    private static final int mJEISyncButtonLeftOffset = 242;
    private static final int mJEISyncButtonTopOffset = 84;
    private static final int mJEISyncButtonSize = 14;
    public static boolean doJEIsync = false;
    private static int OTHER_DIMENSION = 0x77000000;
    private ManifestSearchField searchBox;
    private ScrollBar mScrollBar;
    private GuiButton mEndTrackButton;
    private GuiButton mRefreashButton;
    private GuiButton mConfigButton;
    private GuiButton mAlphaQuantButton;
    private GuiButton mAscDescButton;
    private GuiButton mJEIsync;
    private String storedJEI = "";

    public GUIManifest(EntityPlayer player, ContainerManifest container) {
        super(container);
        this.container = container;
        ClientNetwork network = DataHelper.getClientNetwork(player.func_110124_au());
        network.manifestItems.setListener(container);
        container.setScrollEventManager(this.scrollEventManager);
        this.field_146999_f = 200;
        this.field_147000_g = 224;
        this.player = player;
        if (Loader.isModLoaded((String)"jei")) {
            doJEIsync = ConfigHandler.ManifestConfig.jeiSynchronise;
            this.storedJEI = JEIPlugin.runtime.getIngredientFilter().getFilterText();
        }
    }

    public boolean getJEISync() {
        return doJEIsync;
    }

    public void toggleJEISync() {
        doJEIsync = !doJEIsync;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchBox = new ManifestSearchField(this, 1, this.field_146289_q, this.field_147003_i + 13, this.field_147009_r + 13, 89, 11);
        if (ConfigHandler.ManifestConfig.searchTermPersistence) {
            String searchText = this.container.getSearchString();
            if (searchText == null) {
                searchText = "";
            }
            this.searchBox.func_146180_a(searchText);
        } else {
            this.container.setSearchString("");
        }
        this.searchBox.func_175207_a(this);
        this.searchBox.func_146185_a(false);
        this.mScrollBar = new ScrollBar(10, this.field_147003_i + 178, this.field_147009_r + 29, this.field_147009_r + 191);
        this.scrollEventManager.registerListener(this.mScrollBar);
        this.func_189646_b(this.mScrollBar);
        this.func_189646_b(this.mScrollBar.mNub);
        this.mEndTrackButton = new InvisibleButton(0, this.field_147003_i + 48, this.field_147009_r + 200, 88, 12, "End Tracking");
        this.func_189646_b(this.mEndTrackButton);
        this.mRefreashButton = new InvisibleButton(1, this.field_147003_i + 178, this.field_147009_r + 200, 14, 14, "");
        this.func_189646_b(this.mRefreashButton);
        this.mConfigButton = new InvisibleButton(2, this.field_147003_i + 158, this.field_147009_r + 200, 14, 14, "");
        this.func_189646_b(this.mConfigButton);
        this.mAlphaQuantButton = new InvisibleButton(3, this.field_147003_i + 112, this.field_147009_r + 10, 14, 14, "");
        this.func_189646_b(this.mAlphaQuantButton);
        this.mAscDescButton = new InvisibleButton(4, this.field_147003_i + 130, this.field_147009_r + 10, 14, 14, "");
        this.func_189646_b(this.mAscDescButton);
        this.mJEIsync = new InvisibleButton(5, this.field_147003_i + 148, this.field_147009_r + 10, 14, 14, "");
        this.func_189646_b(this.mJEIsync);
    }

    @Override
    protected void drawTopLevelElements(int mouseX, int mouseY) {
        boolean wasLighting = GL11.glIsEnabled((int)2896);
        GlStateManager.func_179140_f();
        this.searchBox.func_146194_f();
        if (wasLighting) {
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
        this.func_191948_b(mouseX, mouseY);
        GlStateManager.func_179121_F();
    }

    @Override
    protected void drawForegroundContents(int mouseX, int mouseY) {
        super.drawForegroundContents(mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        if (ConfigHandler.UsePrettyGUIs) {
            this.field_146297_k.func_110434_K().func_110577_a(GUIForegroundTextures);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GUIForegroundTexturesSimple);
        }
        GUIManifest.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)256.0f, (float)256.0f);
        if (ConfigHandler.UsePrettyGUIs) {
            this.field_146297_k.func_110434_K().func_110577_a(GUIBaseTextures);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GUIBaseTexturesSimple);
        }
        int alphaQuantShift = 0;
        if (this.container.getSortingType() == ManifestList.SortingType.QUANTITY) {
            alphaQuantShift = 14;
        }
        GUIManifest.func_146110_a((int)112, (int)10, (float)242.0f, (float)(28 + alphaQuantShift), (int)14, (int)14, (float)256.0f, (float)256.0f);
        int ascDescShift = 0;
        if (this.container.getSortingDirection() == ManifestList.SortingDirection.ASCENDING) {
            ascDescShift = 14;
        }
        GUIManifest.func_146110_a((int)130, (int)10, (float)242.0f, (float)(56 + ascDescShift), (int)14, (int)14, (float)256.0f, (float)256.0f);
        int JEISyncShift = 0;
        if (this.getJEISync()) {
            JEISyncShift = 14;
        }
        GUIManifest.func_146110_a((int)148, (int)10, (float)242.0f, (float)(84 + JEISyncShift), (int)14, (int)14, (float)256.0f, (float)256.0f);
    }

    @Override
    protected void drawBackgroundContents(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179142_g();
        if (ConfigHandler.UsePrettyGUIs) {
            this.field_146297_k.func_110434_K().func_110577_a(GUIBaseTextures);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GUIBaseTexturesSimple);
        }
        GUIManifest.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)256.0f, (float)256.0f);
    }

    public void func_146977_a(Slot slot) {
        if (slot.func_111238_b()) {
            ManifestUtils.CollatedEntry entry;
            ItemStack stack = slot.func_75211_c();
            if (!stack.func_190926_b() && ManifestTrackingUtils.matches(stack)) {
                GlStateManager.func_179097_i();
                long worldTime = this.field_146297_k.field_71439_g.field_70170_p.func_72820_D();
                ColorUtils.Color c = ColorUtils.getColorFromTime(worldTime);
                GuiContainer.func_73734_a((int)slot.field_75223_e, (int)slot.field_75221_f, (int)(slot.field_75223_e + 16), (int)(slot.field_75221_f + 16), (int)c.toInteger());
                GlStateManager.func_179126_j();
            }
            super.func_146977_a(slot);
            if (slot instanceof CustomCountSlot) {
                ((CustomCountSlot)slot).renderCount(this.field_146289_q);
            }
            if ((entry = this.container.getEntry(slot.getSlotIndex())) == null) {
                return;
            }
            GlStateManager.func_179140_f();
            if (ConfigHandler.UsePrettyGUIs) {
                this.field_146297_k.func_110434_K().func_110577_a(GUIBaseTextures);
            } else {
                this.field_146297_k.func_110434_K().func_110577_a(GUIBaseTexturesSimple);
            }
            if (!ConfigHandler.ManifestConfig.DisableManifestGrid) {
                GUIManifest.func_146110_a((int)(slot.field_75223_e - 1), (int)(slot.field_75221_f - 1), (float)224.0f, (float)0.0f, (int)18, (int)18, (float)256.0f, (float)256.0f);
            }
            GlStateManager.func_179145_e();
            if (entry.getDimension() != this.player.field_71093_bK || entry.outOfRange) {
                GlStateManager.func_179097_i();
                GUIManifest.drawRectWithBlend(slot.field_75223_e, slot.field_75221_f, slot.field_75223_e + 16, slot.field_75221_f + 16, OTHER_DIMENSION);
                GlStateManager.func_179126_j();
            }
        }
    }

    public static void drawRectWithBlend(int left, int top, int right, int bottom, int color) {
        if (left < right) {
            int i = left;
            left = right;
            right = i;
        }
        if (top < bottom) {
            int j = top;
            top = bottom;
            bottom = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)left, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public void doRefresh() {
        ClientNetwork network = DataHelper.getClientNetwork(this.player.func_110124_au());
        network.synchroniseManifest();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.mEndTrackButton.field_146127_k) {
            LineHandler.clearChests(this.player.field_71093_bK);
        } else if (button.field_146127_k == this.mRefreashButton.field_146127_k) {
            this.doRefresh();
        } else if (button.field_146127_k == this.mConfigButton.field_146127_k) {
            GuiConfig config = new GuiConfig((GuiScreen)this, "arcanearchives", false, false, "Arcane Archives", new Class[]{ConfigHandler.class});
            this.field_146297_k.func_147108_a((GuiScreen)config);
        } else if (button.field_146127_k == this.mAlphaQuantButton.field_146127_k) {
            if (this.container.getSortingType() == ManifestList.SortingType.QUANTITY) {
                this.container.setSortingType(ManifestList.SortingType.NAME);
            } else {
                this.container.setSortingType(ManifestList.SortingType.QUANTITY);
            }
        } else if (button.field_146127_k == this.mAscDescButton.field_146127_k) {
            if (this.container.getSortingDirection() == ManifestList.SortingDirection.ASCENDING) {
                this.container.setSortingDirection(ManifestList.SortingDirection.DESCENDING);
            } else {
                this.container.setSortingDirection(ManifestList.SortingDirection.ASCENDING);
            }
        } else if (button.field_146127_k == this.mJEIsync.field_146127_k) {
            if (!doJEIsync) {
                this.searchBox.syncToJEI(true);
            }
            this.toggleJEISync();
        }
        super.func_146284_a(button);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.searchBox.func_146192_a(mouseX, mouseY, mouseButton)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        this.container.func_184996_a(slotId, mouseButton, type, this.player);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheelState = Mouse.getEventDWheel();
        if (wheelState > 0) {
            this.scrollEventManager.arrowUp();
        } else if (wheelState < 0) {
            this.scrollEventManager.arrowDown();
        }
    }

    public void maybeRestoreJEI() {
        if (Loader.isModLoaded((String)"jei") && doJEIsync && !this.storedJEI.isEmpty()) {
            JEIPlugin.runtime.getIngredientFilter().setFilterText(this.storedJEI);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchBox.func_146206_l() && this.searchBox.func_146201_a(typedChar, keyCode)) {
            return;
        }
        switch (keyCode) {
            case 1: {
                this.maybeRestoreJEI();
                this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)new CPacketCloseWindow(this.field_146297_k.field_71439_g.field_71070_bA.field_75152_c));
                this.field_146297_k.field_71439_g.field_71070_bA = this.field_146297_k.field_71439_g.field_71069_bz;
                this.field_146297_k.field_71439_g.field_71069_bz.field_75152_c = 0;
            }
            case 200: {
                this.scrollEventManager.arrowUp();
                break;
            }
            case 208: {
                this.scrollEventManager.arrowDown();
                break;
            }
            case 201: {
                this.scrollEventManager.pageUp();
                break;
            }
            case 209: {
                this.scrollEventManager.pageDown();
                break;
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List tooltip = this.func_191927_a(stack);
        Slot slot = this.getSlotUnderMouse();
        if (slot != null) {
            ManifestUtils.CollatedEntry entry = this.container.getEntry(slot.field_75222_d);
            if (entry != null && entry.getDimension() != this.player.field_71093_bK) {
                DimensionType dim = DimensionType.func_186069_a((int)entry.getDimension());
                String name = WordUtils.capitalize((String)dim.func_186065_b().replace("_", " "));
                tooltip.add("");
                tooltip.add("" + TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.manifest.inanotherdim", (Object[])new Object[]{name}));
            } else if (entry != null) {
                tooltip.add("");
                tooltip.add("" + TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.manifest.clicktoshow", (Object[])new Object[]{I18n.func_135052_a((String)"arcanearchives.text.manifest.endtrackingbutton", (Object[])new Object[0])}));
            }
            if (entry != null) {
                if (GuiScreen.func_146272_n()) {
                    tooltip.add("");
                    List<ManifestUtils.EntryDescriptor> descriptors = entry.descriptions;
                    int unnamed_count = 1;
                    int limit = Math.min(10, descriptors.size());
                    int diff = Math.max(0, descriptors.size() - limit);
                    for (int i = 0; i < limit; ++i) {
                        ManifestUtils.EntryDescriptor thisEntry = descriptors.get(i);
                        String chestName = thisEntry.string;
                        BlockPos pos = thisEntry.pos;
                        if (chestName.isEmpty()) {
                            chestName = String.format("%s %d", I18n.func_135052_a((String)"arcanearchives.text.radiantchest.unnamed_chest", (Object[])new Object[0]), unnamed_count++);
                        }
                        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"arcanearchives.tooltip.manifest.entry", (Object[])new Object[]{chestName, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), thisEntry.getItemCount()}));
                    }
                    if (diff > 0) {
                        tooltip.add(I18n.func_135052_a((String)"arcanearchives.tooltip.manifest.andmore", (Object[])new Object[]{diff}));
                    }
                } else {
                    tooltip.add("" + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"arcanearchives.tooltip.manifest.chestsneak", (Object[])new Object[0]));
                }
                if (entry.outOfRange) {
                    tooltip.add("" + TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"arcanearchives.tooltip.manifest.outofrange", (Object[])new Object[]{ConfigHandler.ManifestConfig.MaxDistance}));
                }
            }
        }
        this.drawHoveringText(tooltip, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    public void func_175321_a(int id, boolean value) {
    }

    public void func_175320_a(int id, float value) {
    }

    public void func_175319_a(int id, String value) {
        this.container.setSearchString(value);
    }

    public void func_146281_b() {
        this.maybeRestoreJEI();
    }
}

