/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.blocks;

import com.aranaira.arcanearchives.blocks.templates.BlockTemplate;
import com.aranaira.arcanearchives.client.render.LineHandler;
import com.aranaira.arcanearchives.init.BlockRegistry;
import com.aranaira.arcanearchives.tileentities.RadiantTankTileEntity;
import com.aranaira.arcanearchives.util.ItemUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RadiantTank
extends BlockTemplate {
    public static final String NAME = "radiant_tank";
    public static AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.98, 0.9);

    public RadiantTank() {
        super(NAME, Material.field_151592_s);
        this.setSize(1, 1, 1);
        this.func_149715_a(1.0f);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.device.radiant_tank", (Object[])new Object[0]));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (worldIn.field_72995_K) {
            return;
        }
        this.harvesters.set(player);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(RadiantTank.generateStack(te, (IBlockAccess)worldIn, pos));
        ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
        for (ItemStack item : items) {
            RadiantTank.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
        this.harvesters.set(null);
    }

    private static ItemStack generateStack(TileEntity incomingTe, IBlockAccess world, BlockPos pos) {
        if (!(incomingTe instanceof RadiantTankTileEntity)) {
            return new ItemStack((Item)BlockRegistry.RADIANT_TANK.getItemBlock());
        }
        RadiantTankTileEntity te = (RadiantTankTileEntity)incomingTe;
        if (te.wasCreativeDrop) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = new NBTTagCompound();
        te.serializeStack(tag);
        ItemStack stack = new ItemStack((Item)BlockRegistry.RADIANT_TANK.getItemBlock());
        stack.func_77982_d(tag);
        return stack;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        LineHandler.removeLine(pos, player.field_71093_bK);
        if (!world.field_72995_K) {
            RadiantTankTileEntity te;
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_190926_b()) {
                heldItem = player.func_184592_cb();
            }
            if ((te = WorldUtil.getTileEntity(RadiantTankTileEntity.class, (IBlockAccess)world, pos)) == null) {
                return !(heldItem.func_77973_b() instanceof ItemBlock);
            }
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)handler);
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        RadiantTankTileEntity te = WorldUtil.getTileEntity(RadiantTankTileEntity.class, (IBlockAccess)worldIn, pos);
        if (te != null) {
            te.wasCreativeDrop = player.field_71075_bZ.field_75098_d;
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new RadiantTankTileEntity();
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        LineHandler.removeLine(pos, world.field_73011_w.getDimension());
        world.func_175666_e(pos, (Block)this);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        RadiantTankTileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        if (stack.func_77942_o() && (te = WorldUtil.getTileEntity(RadiantTankTileEntity.class, (IBlockAccess)world, pos)) != null) {
            te.deserializeStack(stack.func_77978_p());
            te.func_70296_d();
            te.defaultServerSideUpdate();
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return ItemUtils.calculateRedstoneFromTileEntity(worldIn.func_175625_s(pos));
    }
}

