/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives.blocks;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.blocks.templates.BlockTemplate;
import com.aranaira.arcanearchives.client.render.LineHandler;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.init.ItemRegistry;
import com.aranaira.arcanearchives.network.Networking;
import com.aranaira.arcanearchives.network.PacketRadiantChest;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.util.DropUtils;
import com.aranaira.arcanearchives.util.WorldUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RadiantChest
extends BlockTemplate {
    public static final String NAME = "radiant_chest";

    public RadiantChest() {
        super(NAME, Material.field_151592_s);
        this.func_149715_a(1.0f);
        this.func_149711_c(3.0f);
        this.func_149752_b(6000.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"arcanearchives.tooltip.device.radiant_chest", (Object[])new Object[0]));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        LineHandler.removeLine(pos, playerIn.field_71093_bK);
        ItemStack mainHand = playerIn.func_184614_ca();
        ItemStack offHand = playerIn.func_184592_cb();
        ItemStack displayStack = ItemStack.field_190927_a;
        if (mainHand.func_77973_b() == ItemRegistry.SCEPTER_MANIPULATION && !offHand.func_190926_b()) {
            displayStack = offHand;
        } else if (offHand.func_77973_b() == ItemRegistry.SCEPTER_MANIPULATION && !mainHand.func_190926_b()) {
            displayStack = mainHand;
        }
        boolean clearDisplayed = false;
        if ((mainHand.func_77973_b() == ItemRegistry.SCEPTER_MANIPULATION && offHand.func_190926_b() || offHand.func_77973_b() == ItemRegistry.SCEPTER_MANIPULATION && mainHand.func_190926_b()) && playerIn.func_70093_af()) {
            clearDisplayed = true;
        }
        int dimension = worldIn.field_73011_w.getDimension();
        if (!displayStack.func_190926_b() || clearDisplayed) {
            if (worldIn.field_72995_K) {
                if (clearDisplayed) {
                    PacketRadiantChest.UnsetItem packet = new PacketRadiantChest.UnsetItem(pos, dimension);
                    Networking.CHANNEL.sendToServer((IMessage)packet);
                } else if (!displayStack.func_190926_b()) {
                    PacketRadiantChest.SetItemAndFacing packet = new PacketRadiantChest.SetItemAndFacing(pos, dimension, displayStack, facing);
                    Networking.CHANNEL.sendToServer((IMessage)packet);
                }
            }
        } else if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)ArcaneArchives.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new RadiantChestTileEntity();
    }

    @Override
    public boolean hasOBJModel() {
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te;
        LineHandler.removeLine(pos, worldIn.field_73011_w.getDimension());
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof RadiantChestTileEntity) {
            ServerNetwork network = DataHelper.getServerNetwork(((RadiantChestTileEntity)te).networkId);
            IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            DropUtils.dropInventoryItems(worldIn, pos, inv);
        }
        worldIn.func_175666_e(pos, (Block)this);
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        RadiantChestTileEntity te = WorldUtil.getTileEntity(RadiantChestTileEntity.class, (IBlockAccess)worldIn, pos);
        if (te != null) {
            return te.getInventory().calcRedstone();
        }
        return 0;
    }
}

