/*
 * Decompiled with CFR 0.152.
 */
package com.aranaira.arcanearchives;

import com.aranaira.arcanearchives.ArcaneArchives;
import com.aranaira.arcanearchives.client.gui.GUIBookContainer;
import com.aranaira.arcanearchives.client.gui.GUIBrazier;
import com.aranaira.arcanearchives.client.gui.GUIDevouringCharm;
import com.aranaira.arcanearchives.client.gui.GUIGemCuttersTable;
import com.aranaira.arcanearchives.client.gui.GUIGemSocket;
import com.aranaira.arcanearchives.client.gui.GUIManifest;
import com.aranaira.arcanearchives.client.gui.GUIRadiantChest;
import com.aranaira.arcanearchives.client.gui.GUIRadiantCraftingTable;
import com.aranaira.arcanearchives.client.gui.GUIUpgrades;
import com.aranaira.arcanearchives.data.DataHelper;
import com.aranaira.arcanearchives.data.ServerNetwork;
import com.aranaira.arcanearchives.inventory.ContainerBrazier;
import com.aranaira.arcanearchives.inventory.ContainerDevouringCharm;
import com.aranaira.arcanearchives.inventory.ContainerFakeManifest;
import com.aranaira.arcanearchives.inventory.ContainerGemCuttersTable;
import com.aranaira.arcanearchives.inventory.ContainerGemSocket;
import com.aranaira.arcanearchives.inventory.ContainerManifest;
import com.aranaira.arcanearchives.inventory.ContainerRadiantChest;
import com.aranaira.arcanearchives.inventory.ContainerRadiantCraftingTable;
import com.aranaira.arcanearchives.inventory.ContainerUpgrades;
import com.aranaira.arcanearchives.tileentities.AATileEntity;
import com.aranaira.arcanearchives.tileentities.BrazierTileEntity;
import com.aranaira.arcanearchives.tileentities.GemCuttersTableTileEntity;
import com.aranaira.arcanearchives.tileentities.ImmanenceTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantChestTileEntity;
import com.aranaira.arcanearchives.tileentities.RadiantCraftingTableTileEntity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class AAGuiHandler
implements IGuiHandler {
    public static final int TOME_OF_REQUISITION = 0;
    public static final int RADIANT_CHEST = 1;
    public static final int MANIFEST = 2;
    public static final int GEMCUTTERS_TABLE = 3;
    public static final int RADIANT_CRAFTING_TABLE = 4;
    public static final int MATRIX_STORAGE = 5;
    public static final int MATRIX_REPOSITORY = 6;
    public static final int MATRIX_RESERVOIR = 6;
    public static final int BAUBLE_GEMSOCKET = 7;
    public static final int DEVOURING_CHARM = 8;
    public static final int DEVOURING_CHARM_BACKSIDE = 9;
    public static final int UPGRADES = 10;
    public static final int BRAZIER = 11;

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity te = world.func_175625_s(pos);
        switch (ID) {
            case 0: {
                return null;
            }
            case 2: {
                return new ContainerFakeManifest(player);
            }
            case 7: {
                return new ContainerGemSocket(player);
            }
            case 8: {
                return new ContainerDevouringCharm(player);
            }
        }
        if (!(te instanceof AATileEntity)) {
            return null;
        }
        switch (ID) {
            case 1: {
                return new ContainerRadiantChest((RadiantChestTileEntity)te, player);
            }
            case 3: {
                ServerNetwork network = DataHelper.getServerNetwork(player.func_110124_au());
                network.synchroniseHiveInfo();
                GemCuttersTableTileEntity gct = (GemCuttersTableTileEntity)te;
                return new ContainerGemCuttersTable(gct.getInventory(), gct, player);
            }
            case 4: {
                return new ContainerRadiantCraftingTable((RadiantCraftingTableTileEntity)te, player, player.field_71071_by);
            }
            case 10: {
                return new ContainerUpgrades(player, (ImmanenceTileEntity)te);
            }
            case 11: {
                return new ContainerBrazier((BrazierTileEntity)te, player);
            }
        }
        ArcaneArchives.logger.debug(String.format("Invalid Container ID of %d was passed in; null was returned to the server", ID));
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        TileEntity te = world.func_175625_s(pos);
        switch (ID) {
            case 0: {
                return new GUIBookContainer(null);
            }
            case 2: {
                return new GUIManifest(player, new ContainerManifest(player));
            }
            case 7: {
                return new GUIGemSocket(new ContainerGemSocket(player));
            }
            case 8: {
                return new GUIDevouringCharm(new ContainerDevouringCharm(player));
            }
        }
        if (!(te instanceof AATileEntity)) {
            return null;
        }
        switch (ID) {
            case 1: {
                return new GUIRadiantChest(new ContainerRadiantChest((RadiantChestTileEntity)te, player), player.field_71071_by);
            }
            case 3: {
                GemCuttersTableTileEntity gct = (GemCuttersTableTileEntity)te;
                return new GUIGemCuttersTable(player, new ContainerGemCuttersTable(gct.getInventory(), gct, player));
            }
            case 4: {
                return new GUIRadiantCraftingTable(player, new ContainerRadiantCraftingTable((RadiantCraftingTableTileEntity)te, player, player.field_71071_by));
            }
            case 10: {
                return new GUIUpgrades(new ContainerUpgrades(player, (ImmanenceTileEntity)te), player, (ImmanenceTileEntity)te);
            }
            case 11: {
                return new GUIBrazier(new ContainerBrazier((BrazierTileEntity)te, player));
            }
        }
        ArcaneArchives.logger.debug(String.format("Invalid Container ID of %d was passed in; null was returned to the client.", ID));
        return null;
    }
}

