/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.world;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.silentchaos512.lib.block.BlockOreSL;
import net.silentchaos512.lib.world.WorldGeneratorSL;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.init.ModBlocks;

public class SHWorldGenerator
extends WorldGeneratorSL {
    public SHWorldGenerator(boolean allowRetrogren) {
        super(allowRetrogren, "scalinghealth_retrogen");
    }

    public void generateSurface(World world, Random random, int posX, int posZ) {
        BlockOreSL block = ModBlocks.crystalOre;
        IBlockState state = block.func_176223_P();
        float trueVeinCount = Config.HEART_CRYSTAL_ORE_VEIN_COUNT;
        int spawnX = world.func_175694_M().func_177958_n() / 16;
        int spawnZ = world.func_175694_M().func_177952_p() / 16;
        int chunkX = posX / 16;
        int chunkZ = posZ / 16;
        int deltaX = chunkX - spawnX;
        int deltaZ = chunkZ - spawnZ;
        float distance = (float)Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        int veinCount = (int)(trueVeinCount += Math.min(distance * Config.HEART_CRYSTAL_ORE_EXTRA_VEIN_RATE, Config.HEART_CRYSTAL_ORE_EXTRA_VEIN_CAP));
        if (random.nextFloat() < Config.HEART_CRYSTAL_ORE_VEIN_COUNT - (float)veinCount) {
            ++veinCount;
        }
        int veinSize = Config.HEART_CRYSTAL_ORE_VEIN_SIZE;
        int minHeight = Config.HEART_CRYSTAL_ORE_MIN_HEIGHT;
        int maxHeight = Config.HEART_CRYSTAL_ORE_MAX_HEIGHT;
        for (int i = 0; i < veinCount; ++i) {
            int x = posX + random.nextInt(16);
            int y = random.nextInt(maxHeight - minHeight) + minHeight;
            int z = posZ + random.nextInt(16);
            BlockPos pos = new BlockPos(x, y, z);
            new WorldGenMinable(state, veinSize).func_180709_b(world, random, pos);
        }
    }

    protected void generateNether(World world, Random random, int posX, int posZ) {
    }

    protected void generateEnd(World world, Random random, int posX, int posZ) {
    }
}

