/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.utils.StackProducer;

public class EquipmentTierMap {
    public final int tierCount;
    public final EntityEquipmentSlot slot;
    List<List<StackProducer>> sets;

    public EquipmentTierMap(int tierCount, EntityEquipmentSlot slot) {
        this.tierCount = tierCount;
        this.slot = slot;
        this.sets = new ArrayList<List<StackProducer>>();
        for (int i = 0; i < tierCount; ++i) {
            this.sets.add(new ArrayList());
        }
    }

    public void put(ItemStack stack, int tier) {
        this.put(new StackProducer(stack), tier);
    }

    public void put(StackProducer producer, int tier) {
        if (tier < 0 || tier >= this.tierCount) {
            throw new IllegalArgumentException("tier must be between 0 and " + this.tierCount);
        }
        this.sets.get(tier).add(producer);
    }

    public ItemStack getRandom(int tier) {
        if (tier < 0 || tier >= this.tierCount) {
            throw new IllegalArgumentException("tier must be between 0 and " + this.tierCount);
        }
        List<StackProducer> list = this.sets.get(tier);
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        Random rand = ScalingHealth.random;
        return list.get(rand.nextInt(list.size())).get(rand);
    }

    public ItemStack get(int tier, int index) {
        if (tier < 0 || tier >= this.tierCount) {
            throw new IllegalArgumentException("tier must be between 0 and " + this.tierCount);
        }
        List<StackProducer> list = this.sets.get(tier);
        if (list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (index < 0 || index >= list.size()) {
            throw new IllegalArgumentException("index must be between 0 and " + list.size());
        }
        return list.get(index).get(ScalingHealth.random);
    }
}

