/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.ForgeRegistry;
import svenhjol.meson.Meson;
import svenhjol.meson.registry.ProxyRegistry;

public class RecipeHandler {
    private static final List<ResourceLocation> usedNames = new ArrayList<ResourceLocation>();

    public static void addShapedRecipe(ResourceLocation res, ItemStack output, Object ... inputs) {
        ArrayList pattern = Lists.newArrayList();
        HashMap key = Maps.newHashMap();
        Iterator<Object> iterator = Arrays.asList(inputs).iterator();
        while (iterator.hasNext()) {
            Object input = iterator.next();
            if (input instanceof String) {
                String string = (String)input;
                if (string.length() > 3) {
                    throw new IllegalArgumentException("Invalid string length for recipe " + string.length());
                }
                if (pattern.size() <= 2) {
                    pattern.add(string);
                    continue;
                }
                throw new IllegalArgumentException("Recipe has too many crafting rows!");
            }
            if (input instanceof Character) {
                key.put(((Character)input).toString(), RecipeHandler.asIngredient(iterator.next()));
                continue;
            }
            throw new IllegalArgumentException("Unexpected argument of type " + input.getClass().toString());
        }
        int width = ((String)pattern.get(0)).length();
        int height = pattern.size();
        try {
            key.put(" ", Ingredient.field_193370_a);
            NonNullList<Ingredient> ingredients = RecipeHandler.prepareMaterials(pattern.toArray(new String[0]), key, width, height);
            String group = Objects.requireNonNull(output.func_77973_b().getRegistryName()).toString();
            ShapedRecipes recipe = new ShapedRecipes(group, width, height, ingredients, output);
            RecipeHandler.addRecipe(res, (IRecipe)recipe);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static void addShapedRecipe(ItemStack output, Object ... inputs) {
        String namespace = RecipeHandler.getNamespace();
        ResourceLocation res = RecipeHandler.getUnusedResourceLocation(namespace, output);
        RecipeHandler.addShapedRecipe(res, output, inputs);
    }

    public static void addShapelessRecipe(ResourceLocation res, ItemStack output, Object ... inputs) {
        NonNullList ingredients = NonNullList.func_191196_a();
        for (Object input : inputs) {
            ingredients.add((Object)RecipeHandler.asIngredient(input));
        }
        if (ingredients.isEmpty()) {
            throw new IllegalArgumentException("No ingredients for shapeless recipe!");
        }
        if (ingredients.size() > 9) {
            throw new IllegalArgumentException("Too many ingredients for shapeless recipe!");
        }
        String group = Objects.requireNonNull(output.func_77973_b().getRegistryName()).toString();
        ShapelessRecipes recipe = new ShapelessRecipes(group, output, ingredients);
        RecipeHandler.addRecipe(res, (IRecipe)recipe);
    }

    public static void addShapelessRecipe(ItemStack output, Object ... inputs) {
        String namespace = RecipeHandler.getNamespace();
        ResourceLocation res = RecipeHandler.getUnusedResourceLocation(namespace, output);
        RecipeHandler.addShapelessRecipe(res, output, inputs);
    }

    public static void addRecipe(ResourceLocation res, IRecipe recipe) {
        Meson.debug("Adding recipe " + res.toString());
        recipe.setRegistryName(res);
        ProxyRegistry.register(recipe);
        usedNames.add(res);
    }

    public static void removeRecipeByOutput(ItemStack stack) {
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.RECIPES;
        ArrayList recipes = Lists.newArrayList((Iterable)registry.getValues());
        for (IRecipe recipe : recipes) {
            if (recipe.func_77571_b() != stack) continue;
            registry.remove(recipe.getRegistryName());
        }
    }

    public static void removeRecipeByRegistryName(ResourceLocation name) {
        ForgeRegistry registry = (ForgeRegistry)ForgeRegistries.RECIPES;
        ArrayList recipes = Lists.newArrayList((Iterable)registry.getValues());
        for (IRecipe recipe : recipes) {
            if (!Objects.requireNonNull(recipe.getRegistryName()).equals((Object)name)) continue;
            registry.remove(name);
        }
    }

    public static Ingredient asIngredient(Object object) {
        if (object instanceof Ingredient) {
            return (Ingredient)object;
        }
        if (object instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)object));
        }
        if (object instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ProxyRegistry.newStack((Block)object)});
        }
        if (object instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)object});
        }
        if (object instanceof String) {
            return new OreIngredient((String)object);
        }
        throw new IllegalArgumentException("Cannot convert object of type " + object.getClass().toString() + "to an Ingredient!");
    }

    private static String getNamespace() {
        return Objects.requireNonNull(Loader.instance().activeModContainer()).getModId();
    }

    private static ResourceLocation getUnusedResourceLocation(String namespace, ItemStack output) {
        ResourceLocation base;
        ResourceLocation unused = base = new ResourceLocation(namespace, Objects.requireNonNull(output.func_77973_b().getRegistryName()).func_110623_a());
        int i = 0;
        while (usedNames.contains(unused)) {
            unused = new ResourceLocation(namespace, base.func_110623_a() + "_" + ++i);
        }
        return unused;
    }

    private static NonNullList<Ingredient> prepareMaterials(String[] pattern, Map<String, Ingredient> key, int width, int height) {
        NonNullList list = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String s = pattern[i].substring(j, j + 1);
                Ingredient ingredient = key.get(s);
                list.set(j + width * i, (Object)ingredient);
            }
        }
        return list;
    }
}

