/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.handler;

import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.meson.iface.IMesonBlock;
import svenhjol.meson.iface.IMesonItem;
import svenhjol.meson.registry.ProxyRegistry;

public final class ModelHandler {
    @SubscribeEvent
    public static void onRegister(ModelRegistryEvent event) {
        ProxyRegistry.items.forEach(ModelHandler::registerModels);
        ProxyRegistry.blocks.forEach(ModelHandler::registerBlockModels);
    }

    @SubscribeEvent
    public static void onItemColorRegister(ColorHandlerEvent.Item event) {
        for (Item item : ProxyRegistry.items) {
            if (!(item instanceof IMesonItem.IItemColorHandler)) continue;
            IItemColor col = ((IMesonItem.IItemColorHandler)item).getItemColor();
            event.getItemColors().func_186730_a(col, new Item[]{item});
        }
    }

    public static void registerModels(Item item) {
        int meta = 0;
        if (item instanceof IMesonItem.IItemCustomModel) {
            ((IMesonItem.IItemCustomModel)item).registerModels(item);
        } else {
            ModelResourceLocation loc = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)loc);
        }
        if (item instanceof IMesonItem.IItemVariants) {
            List<ResourceLocation> variants = ((IMesonItem.IItemVariants)item).getVariants();
            for (int i = 0; i < variants.size(); ++i) {
                ModelResourceLocation loc = new ModelResourceLocation(variants.get(i), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
            }
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])variants.toArray(new ResourceLocation[0]));
        }
        if (item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof IMesonBlock) {
            IMesonBlock block = (IMesonBlock)((ItemBlock)item).func_179223_d();
            String[] variants = block.getVariants();
            String name = block.getModId() + ":" + block.getName();
            if (variants.length > 1) {
                for (int i = 0; i < variants.length; ++i) {
                    String variant = variants[i];
                    ModelResourceLocation inv = new ModelResourceLocation(name, "inventory,variant=" + variant);
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)inv);
                }
            } else {
                ModelResourceLocation loc = new ModelResourceLocation(name, "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)loc);
            }
            if (block instanceof IMesonBlock.IHasCustomStateMapper) {
                ((IMesonBlock.IHasCustomStateMapper)((Object)block)).setStateMapper();
            }
            ModelResourceLocation loc = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)loc);
        }
    }

    public static void registerBlockModels(Block block) {
        if (block instanceof IMesonBlock.IHasCustomStateMapper) {
            ((IMesonBlock.IHasCustomStateMapper)block).setStateMapper();
        }
        if (block instanceof IMesonBlock.IHasCustomItemBlockModel) {
            ((IMesonBlock.IHasCustomItemBlockModel)block).setInventoryItemModel();
        } else {
            int meta = 0;
            Item item = Item.func_150898_a((Block)block);
            ModelResourceLocation loc = new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)loc);
        }
    }
}

