/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.decorator;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockCake;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import svenhjol.meson.MesonTileInventory;
import svenhjol.meson.decorator.MesonDecoratorTheme;
import svenhjol.meson.decorator.MesonInnerDecorator;
import svenhjol.meson.helper.EntityHelper;

public class MesonDecoratorItems {
    protected MesonInnerDecorator generator;
    protected MesonDecoratorTheme theme;
    protected Random rand;
    protected World world;
    protected StructureBoundingBox box;
    protected StructureComponent structure;

    public MesonDecoratorItems(MesonInnerDecorator generator) {
        this.generator = generator;
        this.world = generator.getWorld();
        this.rand = generator.getRand();
        this.theme = generator.getTheme();
        this.box = generator.getBox();
        this.structure = generator.getStructure();
    }

    public void addStorageBlock(int x, int y, int z, EnumFacing facing) {
        IBlockState type = this.theme.getStorageBlock();
        this.addStorageBlock(type, x, y, z, facing);
    }

    public void addStorageBlock(IBlockState type, int x, int y, int z, EnumFacing facing) {
        this.addStorageBlock(type, x, y, z, facing, this.theme.getLootTable(), 0);
    }

    public void addStorageBlock(IBlockState type, int x, int y, int z, EnumFacing facing, ResourceLocation loot, int lootSize) {
        BlockPos place = new BlockPos(x, y, z);
        TileEntity tile = this.generator.addTileEntity(place, type, facing);
        if (tile instanceof MesonTileInventory) {
            ((MesonTileInventory)tile).setLootTable(loot, lootSize);
        } else if (tile instanceof TileEntityChest) {
            ((TileEntityChest)tile).func_189404_a(loot, this.world.field_73012_v.nextLong());
        }
    }

    public void addFunctionalBlock(int x, int y, int z, EnumFacing facing) {
        this.generator.add(this.theme.getFunctionalBlock(), x, y, z, facing);
    }

    public void addDecorationBlock(int x, int y, int z, EnumFacing facing) {
        this.generator.add(this.theme.getDecorationBlock(), x, y, z, facing);
    }

    public void addRandomBlock(int x, int y, int z, EnumFacing facing) {
        float f = this.rand.nextFloat();
        if (f <= 0.5f) {
            this.addFunctionalBlock(x, y, z, facing);
        } else {
            this.addDecorationBlock(x, y, z, facing);
        }
    }

    public void addArmorStand(int x, int y, int z, float angle) {
        BlockPos place = new BlockPos(x, y, z);
        this.addArmorStand(place, angle, this.theme.getWearables());
    }

    public void addArmorStand(BlockPos pos, float angle, @Nullable Map<EntityEquipmentSlot, ItemStack> wearing) {
        BlockPos place = this.generator.getRelativePos(pos);
        if (this.generator.isNotInBox(place)) {
            return;
        }
        EntityArmorStand stand = new EntityArmorStand(this.world, (double)((float)place.func_177958_n() + 0.5f), (double)place.func_177956_o(), (double)((float)place.func_177952_p() + 0.5f));
        if (wearing != null) {
            ArrayList<EntityEquipmentSlot> slots = new ArrayList<EntityEquipmentSlot>(){
                {
                    this.add(EntityEquipmentSlot.HEAD);
                    this.add(EntityEquipmentSlot.CHEST);
                    this.add(EntityEquipmentSlot.LEGS);
                    this.add(EntityEquipmentSlot.FEET);
                    this.add(EntityEquipmentSlot.MAINHAND);
                    this.add(EntityEquipmentSlot.OFFHAND);
                }
            };
            slots.forEach(slot -> {
                if (wearing.get(slot) != null) {
                    stand.func_184201_a(slot, (ItemStack)wearing.get(slot));
                }
            });
        }
        this.world.func_175698_g(place);
        this.world.func_175698_g(place.func_177984_a());
        stand.func_70012_b((double)((float)place.func_177958_n() + 0.5f), (double)place.func_177956_o(), (double)((float)place.func_177952_p() + 0.5f), this.generator.getRotatedAngle(this.structure.func_186165_e(), angle), 0.0f);
        this.world.func_72838_d((Entity)stand);
    }

    public void addAnvil(int x, int y, int z, int damage, @Nullable EnumFacing facing) {
        IBlockState anvil = Blocks.field_150467_bQ.func_176223_P().func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(damage));
        this.generator.add(anvil, x, y, z, facing);
    }

    public void addFramedItem(int x, int y, int z, EnumFacing direction) {
        BlockPos place = new BlockPos(x, y, z);
        this.addFramedItem(place, direction, this.theme.getFramedItem());
    }

    public void addFramedItem(BlockPos pos, EnumFacing facing, @Nullable ItemStack displayedItem) {
        BlockPos place = this.generator.getRelativePos(pos);
        if (this.generator.isNotInBox(place)) {
            return;
        }
        EntityItemFrame frame = new EntityItemFrame(this.world, place, this.generator.getRelativeFacing(facing));
        if (displayedItem != null) {
            frame.func_82334_a(displayedItem);
        }
        this.world.func_72838_d((Entity)frame);
    }

    public void addPainting(int x, int y, int z, EnumFacing direction) {
        BlockPos place = new BlockPos(x, y, z);
        this.addPainting(place, direction);
    }

    public void addPainting(BlockPos pos, EnumFacing facing) {
        BlockPos place = this.generator.getRelativePos(pos);
        if (this.generator.isNotInBox(place)) {
            return;
        }
        EntityPainting painting = new EntityPainting(this.world, place, this.generator.getRelativeFacing(facing));
        this.world.func_72838_d((Entity)painting);
    }

    public void addRug(int floor, int x0, int z0, int x1, int z1, @Nullable Random rand) {
        if (rand == null) {
            rand = this.generator.getRand();
        }
        IBlockState carpet1 = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.func_176766_a((int)rand.nextInt(15)));
        IBlockState carpet2 = Blocks.field_150404_cg.func_176223_P().func_177226_a((IProperty)BlockCarpet.field_176330_a, (Comparable)EnumDyeColor.func_176766_a((int)rand.nextInt(15)));
        int style = rand.nextInt(3) + 1;
        int i = 0;
        for (int xx = x0; xx <= x1; ++xx) {
            for (int zz = z0; zz <= z1; ++zz) {
                IBlockState carpet = i % style == 0 ? carpet1 : carpet2;
                ++i;
                this.generator.add(carpet, xx, floor, zz);
            }
        }
    }

    public void addDoor(int x, int y, int z, EnumFacing facing, BlockDoor door) {
        this.generator.addRow(this.getDoor(door), x, y, z, EnumFacing.UP, facing);
    }

    public void addStand(int x, int y, int z, EnumFacing facing, @Nullable IBlockState onTop) {
        if (onTop == null) {
            switch (this.rand.nextInt(2)) {
                case 0: {
                    onTop = this.getCake();
                    break;
                }
                case 1: {
                    onTop = this.getFlowerPot();
                }
            }
        }
        if (onTop != null) {
            this.generator.add(Blocks.field_150344_f.func_176223_P(), x, y, z, facing);
            this.generator.add(onTop, x, y + 1, z, facing);
        } else {
            this.addRandomBlock(x, y, z, facing);
        }
    }

    public void addTorch(int x, int y, int z, @Nullable EnumFacing facing) {
        IBlockState torch = Blocks.field_150478_aa.func_176223_P();
        if (facing != null) {
            torch = torch.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
        }
        this.generator.add(torch, x, y, z);
    }

    public List<IBlockState> getBed() {
        ArrayList<IBlockState> bed = new ArrayList<IBlockState>();
        bed.add(Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD));
        bed.add(Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT));
        return bed;
    }

    public List<IBlockState> getDoor(BlockDoor door) {
        ArrayList<IBlockState> d = new ArrayList<IBlockState>();
        d.add(door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER));
        d.add(door.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER));
        return d;
    }

    public IBlockState getCake() {
        return Blocks.field_150414_aQ.func_176223_P().func_177226_a((IProperty)BlockCake.field_176589_a, (Comparable)Integer.valueOf(this.generator.getRand().nextInt(2)));
    }

    public IBlockState getFlowerPot() {
        return this.getFlowerPot(this.generator.getRand().nextInt(14) + 1);
    }

    public IBlockState getFlowerPot(int flowerType) {
        return Blocks.field_150457_bL.func_176223_P().func_177226_a((IProperty)BlockFlowerPot.field_176444_a, (Comparable)Integer.valueOf(flowerType));
    }

    public void spawnCat(int x, int y, int z, int skin, boolean tamed, @Nullable EntityPlayer player) {
        BlockPos posForMob = this.generator.getRelativePos(new BlockPos(x, y, z));
        if (this.generator.isNotInBox(posForMob)) {
            return;
        }
        Entity entity = EntityHelper.spawnEntity(new ResourceLocation("minecraft:ocelot"), this.world, posForMob);
        if (entity != null) {
            EntityOcelot cat = (EntityOcelot)entity;
            cat.func_70912_b(skin);
            if (tamed) {
                cat.func_70903_f(true);
                if (player != null) {
                    cat.func_184754_b(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
                }
            }
        }
    }
}

