/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.meson.asm;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;
import svenhjol.meson.Meson;
import svenhjol.meson.asm.ClassNameMap;
import svenhjol.meson.asm.MesonLoadingPlugin;
import svenhjol.meson.helper.ConfigHelper;

public abstract class MesonClassTransformer
implements IClassTransformer {
    protected static final Map<String, Transformer> transformers = new HashMap<String, Transformer>();
    protected static ClassNameMap CLASS_MAPPINGS = null;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformers.containsKey(transformedName)) {
            return (byte[])transformers.get(transformedName).apply(basicClass);
        }
        return basicClass;
    }

    @SafeVarargs
    public static byte[] transform(byte[] basicClass, Pair<MethodSignature, MethodAction> ... methods) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean didAnything = false;
        for (Pair<MethodSignature, MethodAction> pair : methods) {
            MesonClassTransformer.log("Applying Transformation to method (" + pair.getLeft() + ")");
            didAnything |= MesonClassTransformer.findMethodAndTransform(node, (MethodSignature)pair.getLeft(), (MethodAction)pair.getRight());
        }
        if (didAnything) {
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static MethodAction combine(NodeFilter filter, NodeAction action) {
        return mnode -> MesonClassTransformer.applyOnNode(mnode, filter, action);
    }

    public static boolean applyOnNode(MethodNode method, NodeFilter filter, NodeAction action) {
        ListIterator iterator = method.instructions.iterator();
        boolean applied = false;
        while (iterator.hasNext()) {
            AbstractInsnNode anode = (AbstractInsnNode)iterator.next();
            if (!filter.test(anode)) continue;
            MesonClassTransformer.log("Located target " + MesonClassTransformer.getNodeString(anode));
            applied = true;
            if (!action.test(method, anode)) continue;
            break;
        }
        return applied;
    }

    public static boolean findMethodAndTransform(ClassNode node, MethodSignature sig, MethodAction pred) {
        String funcName = sig.funcName;
        if (MesonLoadingPlugin.obf) {
            funcName = sig.srgName;
        }
        for (MethodNode method : node.methods) {
            if (!method.name.equals(funcName) && !method.name.equals(sig.obfName) && !method.name.equals(sig.srgName) || !method.desc.equals(sig.funcDesc) && !method.desc.equals(sig.obfDesc)) continue;
            MesonClassTransformer.log("Located method, patching...");
            boolean finish = pred.test(method);
            MesonClassTransformer.log("Patch result: " + finish);
            return finish;
        }
        MesonClassTransformer.log("Failed to locate the method!");
        return false;
    }

    public static boolean checkDesc(String desc, String expected) {
        return desc.equals(expected) || desc.equals(MethodSignature.obfuscate(expected));
    }

    public static String getNodeString(AbstractInsnNode node) {
        Textifier printer = new Textifier();
        TraceMethodVisitor visitor = new TraceMethodVisitor((Printer)printer);
        node.accept((MethodVisitor)visitor);
        StringWriter sw = new StringWriter();
        printer.print(new PrintWriter(sw));
        printer.getText().clear();
        return sw.toString().replaceAll("\n", "").trim();
    }

    public static void log(String string) {
        LogManager.getLogger((String)"Meson ASM").info(string);
    }

    public static boolean checkTransformers(Configuration config, String ... transformers) {
        boolean loaded = true;
        for (String transformer : transformers) {
            loaded = loaded && ConfigHelper.propBoolean(config, transformer, "Transformers", "", true);
        }
        config.setCategoryComment("Transformers", "This section contains core class patches.\nYou may disable these patches in case of compatibility problems.\nAny features that depend on a manually disabled patch will not work properly.");
        if (config.hasChanged()) {
            config.save();
        }
        return loaded;
    }

    public static boolean obf() {
        return MesonLoadingPlugin.obf;
    }

    public static class MethodSignature {
        public String funcName;
        public String srgName;
        public String obfName;
        public String funcDesc;
        public String obfDesc;

        public MethodSignature(String funcName, String srgName, String obfName, String funcDesc) {
            this.funcName = funcName;
            this.srgName = srgName;
            this.obfName = obfName;
            this.funcDesc = funcDesc;
            this.obfDesc = MethodSignature.obfuscate(funcDesc);
        }

        public String toString() {
            return "Names [" + this.funcName + ", " + this.srgName + ", " + this.obfName + "] Descriptor " + this.funcDesc + " / " + this.obfDesc;
        }

        public static String obfuscate(String desc) {
            for (String s : CLASS_MAPPINGS.keySet()) {
                int i = 0;
                while (desc.contains(s)) {
                    desc = desc.replace(s, (CharSequence)CLASS_MAPPINGS.get(s));
                    if (i++ <= 10) continue;
                    Meson.fatal("Nope");
                }
            }
            return desc;
        }
    }

    public static interface NodeAction
    extends BiPredicate<MethodNode, AbstractInsnNode> {
    }

    public static interface NodeFilter
    extends Predicate<AbstractInsnNode> {
    }

    public static interface MethodAction
    extends Predicate<MethodNode> {
    }

    public static interface Transformer
    extends Function<byte[], byte[]> {
    }
}

