/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.world.feature.Spectre;
import svenhjol.meson.Feature;
import svenhjol.meson.Meson;
import svenhjol.meson.helper.EntityHelper;
import svenhjol.meson.helper.WorldHelper;

public class SpectreHaunting
extends Feature {
    public static WorldHelper.StructureType structure;
    public static int distance;
    public static int checkInterval;
    public static int spawnMinDistance;
    public static int spawnRange;
    public static int ticksLiving;
    public static int mobcap;
    public static float spawnChance;

    @Override
    public String getDescription() {
        return "Spectres will spawn in greater numbers within range of specific structure.";
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && Charm.hasFeature(Spectre.class);
    }

    @Override
    public void configure() {
        super.configure();
        spawnChance = (float)this.propDouble("Spawn chance during haunt", "Chance (out of 1.0) of a spectre spawning every two seconds during a haunt.\n", 0.25);
        int secondsLiving = this.propInt("Spectre lifetime", "How long a spectre should live for, in seconds.\nThis affects all spectres, not just those spawned in the haunt.", 20);
        mobcap = this.propInt("Check mobcap", "Only spawns a spectre for haunting if number of monster entities is lower than this number.\nVanilla minecraft is around 75.", 80);
        String hauntStructure = this.propString("Structure to haunt", "Name of structure that spectres will haunt.", WorldHelper.StructureType.STRONGHOLD.getCapitalizedName());
        checkInterval = 40;
        distance = 7500;
        ticksLiving = secondsLiving * 20;
        spawnMinDistance = 18;
        spawnRange = 5;
        structure = WorldHelper.StructureType.valueOf(hauntStructure.toUpperCase());
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        WorldHelper.populateWorldSettings(event.getWorld());
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer() && event.player != null && event.player.field_70170_p != null && WorldHelper.canGenerateStructures(event.player.field_70170_p) && WorldHelper.canGenerateStructure(event.player.field_70170_p, structure) && event.player.field_70170_p.func_82737_E() % (long)checkInterval == 0L && event.player.field_70170_p.field_73012_v.nextFloat() < spawnChance && (double)event.player.field_70170_p.func_175724_o(event.player.func_180425_c()) < (double)Spectre.despawnLight / 16.0) {
            WorldServer world = (WorldServer)event.player.field_70170_p;
            EnumCreatureType monster = EnumCreatureType.MONSTER;
            int count = world.countEntities(monster, true);
            if (count <= mobcap) {
                BlockPos nearest = WorldHelper.getNearestStructure(event.player.field_70170_p, event.player.func_180425_c(), structure);
                if (nearest != null && WorldHelper.getDistanceSq(event.player.func_180425_c(), nearest) < (double)distance) {
                    Meson.debug("Spectre haunting ", event.player.func_180425_c());
                    EntityHelper.spawnEntityNearPlayer(event.player, spawnMinDistance, spawnRange, new ResourceLocation("charm", "spectre"));
                }
            } else {
                Meson.debug("Mobcap reached, not spawning spectre");
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

