/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.smithing.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.world.feature.TotemOfReturning;
import svenhjol.charm.world.item.ItemTotemOfReturning;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.ItemHelper;

public class ExtendTotemOfReturning
extends Feature {
    public static int xpCost;
    public static Map<String, Integer> useItemMap;

    @Override
    public String getDescription() {
        return "Combine a Totem of Returning with a clock on an anvil to increase the number of times it can be used.";
    }

    @Override
    public void configure() {
        String[] items;
        super.configure();
        xpCost = this.propInt("XP cost", "Amount of XP (levels) required to increase the number of times a Totem of Returning can be used.", 5);
        for (String line : items = this.propStringList("Items and uses", "A map of items and the amount of uses they add to the totem.\nFormat is 'modid:name[meta]->uses'.  If meta is not set, or '*', all meta values of the item will be used.", new String[]{"minecraft:clock->1", "minecraft:sapling[2]->2"})) {
            String[] split = line.split("->");
            if (split.length != 2) continue;
            useItemMap.put(split[0], Integer.parseInt(split[1]));
        }
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        String name;
        if (!Charm.hasFeature(TotemOfReturning.class)) {
            return;
        }
        ItemStack in = event.getLeft();
        ItemStack combine = event.getRight();
        if (!(in.func_190926_b() || combine.func_190926_b() || in.func_77973_b() != TotemOfReturning.totem || (name = ItemHelper.getMatchingItemKey(new ArrayList<String>(useItemMap.keySet()), combine)).isEmpty())) {
            int amount = useItemMap.get(name);
            ItemStack out = in.func_77946_l();
            int uses = ItemTotemOfReturning.getUses(out);
            ItemTotemOfReturning.setUses(out, uses + amount);
            event.setOutput(out);
            event.setMaterialCost(1);
            event.setCost(xpCost);
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        useItemMap = new HashMap<String, Integer>();
    }
}

