/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.enchantment;

import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import svenhjol.charm.enchanting.feature.ExtraCurses;
import svenhjol.meson.MesonEnchantment;
import svenhjol.meson.helper.EnchantmentHelper;
import svenhjol.meson.iface.IMesonEnchantment;

public class EnchantmentRustingCurse
extends MesonEnchantment
implements IMesonEnchantment.ICurse {
    private int rustDamage = ExtraCurses.rustingDamage;

    public EnchantmentRustingCurse() {
        super("rusting_curse", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.ALL, EntityEquipmentSlot.MAINHAND);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public void onBreak(EntityPlayer player, BlockEvent.BreakEvent event) {
        if (this.isHeldItemEnchanted(player, this, EnumHand.MAIN_HAND)) {
            this.damageItem(player, player.func_184614_ca());
        }
        if (this.isHeldItemEnchanted(player, this, EnumHand.OFF_HAND)) {
            this.damageItem(player, player.func_184592_cb());
        }
    }

    @Override
    public void onInteract(EntityPlayer player, PlayerInteractEvent.RightClickBlock event) {
        if (this.isHeldItemEnchanted(player, this, EnumHand.MAIN_HAND)) {
            this.damageItem(player, player.func_184614_ca());
        }
        if (this.isHeldItemEnchanted(player, this, EnumHand.OFF_HAND)) {
            this.damageItem(player, player.func_184592_cb());
        }
    }

    @Override
    public void onAttack(EntityPlayer player, AttackEntityEvent event) {
        if (this.isHeldItemEnchanted(player, this, EnumHand.MAIN_HAND)) {
            this.damageItem(player, player.func_184614_ca());
        }
        if (this.isHeldItemEnchanted(player, this, EnumHand.OFF_HAND)) {
            this.damageItem(player, player.func_184592_cb());
        }
    }

    @Override
    public void onItemUseStop(EntityPlayer player, LivingEntityUseItemEvent.Stop event) {
        if (this.isHeldItemEnchanted(player, this, EnumHand.MAIN_HAND)) {
            this.damageItem(player, player.func_184614_ca());
        }
    }

    @Override
    public void onDamage(EntityPlayer player, LivingDamageEvent event) {
        for (ItemStack item : player.func_184209_aF()) {
            if (!EnchantmentHelper.hasEnchantment(this, item)) continue;
            this.damageItem(player, item);
        }
    }

    private void damageItem(EntityPlayer player, ItemStack item) {
        item.func_96631_a(new Random().nextInt(this.rustDamage), player.field_70170_p.field_73012_v, (EntityPlayerMP)player);
    }
}

