/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.enchanting.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import svenhjol.charm.enchanting.feature.ExtraCurses;
import svenhjol.meson.MesonEnchantment;
import svenhjol.meson.helper.EntityHelper;
import svenhjol.meson.iface.IMesonEnchantment;

public class EnchantmentHauntingCurse
extends MesonEnchantment
implements IMesonEnchantment.ICurse {
    private double spawnChance = ExtraCurses.hauntingSpawnChance;
    private int spawnRange = ExtraCurses.hauntingSpawnRange;
    private String[] spawnableMobs = ExtraCurses.hauntingMobs;

    public EnchantmentHauntingCurse() {
        super("haunting_curse", Enchantment.Rarity.VERY_RARE, EnumEnchantmentType.WEAPON, EntityEquipmentSlot.MAINHAND);
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public void onBreak(EntityPlayer player, BlockEvent.BreakEvent event) {
        this.trySpawn(player);
    }

    @Override
    public void onInteract(EntityPlayer player, PlayerInteractEvent.RightClickBlock event) {
        this.trySpawn(player);
    }

    @Override
    public void onAttack(EntityPlayer player, AttackEntityEvent event) {
        this.trySpawn(player);
    }

    private void trySpawn(EntityPlayer player) {
        if (this.isHeldItemEnchanted(player, this) && (double)player.field_70170_p.field_73012_v.nextFloat() < this.spawnChance) {
            String mob = this.spawnableMobs[player.field_70170_p.field_73012_v.nextInt(this.spawnableMobs.length)];
            EntityHelper.spawnEntityNearPlayer(player, this.spawnRange, new ResourceLocation(mob));
        }
    }
}

