/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import svenhjol.charm.crafting.block.BlockComposter;
import svenhjol.charm.crafting.message.MessageComposterAddLevel;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.handler.RecipeHandler;
import svenhjol.meson.helper.ItemHelper;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.registry.ProxyRegistry;

public class Composter
extends Feature {
    public static BlockComposter composter;
    public static Map<String, Float> inputs;
    public static List<String> outputs;
    public static int maxOutput;

    @Override
    public String getDescription() {
        return "Right-click the composter with organic items to add them.  When the composter is full, bonemeal will be returned.";
    }

    @Override
    public void configure() {
        String[] items;
        super.configure();
        for (String item : items = this.propStringList("Items with 30% chance", "These items have a 30% chance of adding a level of compost.", new String[]{"minecraft:beetroot_seeds", "minecraft:grass", "minecraft:leaves", "minecraft:leaves2", "minecraft:melon_seeds", "minecraft:pumpkin_seeds", "minecraft:sapling", "minecraft:wheat_seeds", "quark:leaf_carpet", "inspirations:enlightened_bush", "inspirations:cactus_seeds", "inspirations:sugar_cane_seeds", "inspirations:carrot_seeds", "inspirations:potato_seeds"})) {
            inputs.put(item, Float.valueOf(0.3f));
        }
        for (String item : items = this.propStringList("Items with 50% chance", "These items have a 50% chance of adding a level of compost.", new String[]{"minecraft:cactus", "minecraft:melon", "minecraft:reeds", "minecraft:double_plant", "minecraft:tallgrass", "quark:roots", "quark:roots_black_flower", "quark:roots_blue_flower", "quark:roots_white_flower"})) {
            inputs.put(item, Float.valueOf(0.5f));
        }
        for (String item : items = this.propStringList("Items with 65% chance", "These items have a 65% chance of adding a level of compost.", new String[]{"minecraft:apple", "minecraft:beetroot", "minecraft:carrot", "minecraft:dye[3]", "minecraft:tallgrass[2]", "minecraft:yellow_flower", "minecraft:red_flower", "minecraft:red_mushroom", "minecraft:brown_mushroom", "minecraft:potato", "minecraft:poisonous_potato", "minecraft:pumpkin", "minecraft:wheat", "quark:root_flower", "inspirations:flower", "inspirations:materials[4]", "inspirations:materials[5]", "inspirations:edibles[0]"})) {
            inputs.put(item, Float.valueOf(0.65f));
        }
        for (String item : items = this.propStringList("Items with 85% chance", "These items have a 85% chance of adding a level of compost.", new String[]{"minecraft:baked_potato", "minecraft:bread", "minecraft:cookie", "minecraft:hay_block", "minecraft:red_mushroom_block", "minecraft:brown_mushroom_block", "quark:turf"})) {
            inputs.put(item, Float.valueOf(0.85f));
        }
        for (String item : items = this.propStringList("Items with 100% chance", "These items have a 100% chance of adding a level of compost.", new String[]{"minecraft:cake", "minecraft:pumpkin_pie", "quark:reed_block"})) {
            inputs.put(item, Float.valueOf(1.0f));
        }
        items = this.propStringList("Output from composter", "Items that may be produced by the composter when it is full.", new String[]{"minecraft:dye[15]"});
        outputs.addAll(Arrays.asList(items));
        maxOutput = this.propInt("Maximum number of output items", "Sets the maximum stack size of the composter output.", 3);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        composter = new BlockComposter();
        GameRegistry.registerTileEntity(composter.getTileEntityClass(), (ResourceLocation)new ResourceLocation("charm:composter"));
        NetworkHandler.register(MessageComposterAddLevel.class, Side.CLIENT);
        RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(composter), "F F", "F F", "PPP", Character.valueOf('F'), "fenceWood", Character.valueOf('P'), "plankWood");
    }

    @SideOnly(value=Side.CLIENT)
    public static void levelAdded(BlockPos pos, int level) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        SoundEvent sound = level == 8 ? SoundEvents.field_187638_cR : SoundEvents.field_187693_cj;
        SoundHelper.playSoundAtPos((World)world, pos, sound, 1.0f, 1.0f);
    }

    public static Map<Float, List<String>> getInputsByChance() {
        HashMap<Float, List<String>> inputsByChance = new HashMap<Float, List<String>>();
        for (String s : inputs.keySet()) {
            float chance = inputs.get(s).floatValue();
            if (!inputsByChance.containsKey(Float.valueOf(chance))) {
                inputsByChance.put(Float.valueOf(chance), new ArrayList());
            }
            ((List)inputsByChance.get(Float.valueOf(chance))).add(s);
        }
        return inputsByChance;
    }

    public static boolean hasInput(ItemStack inputStack) {
        if (inputStack.func_190926_b()) {
            return false;
        }
        String itemName = ItemHelper.getItemStringFromItemStack(inputStack, true);
        if (inputs.containsKey(itemName) || inputs.containsKey(itemName.substring(0, itemName.indexOf(91)))) {
            return true;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)inputStack)) {
            if (!inputs.containsKey("ore:" + OreDictionary.getOreName((int)id))) continue;
            return true;
        }
        return false;
    }

    public static float getItemChance(ItemStack inputStack) {
        if (inputStack.func_190926_b()) {
            return 0.0f;
        }
        String itemName = ItemHelper.getItemStringFromItemStack(inputStack, true);
        if (inputs.containsKey(itemName)) {
            return inputs.get(itemName).floatValue();
        }
        if (inputs.containsKey(itemName = itemName.substring(0, itemName.indexOf(91)))) {
            return inputs.get(itemName).floatValue();
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)inputStack)) {
            if (!inputs.containsKey("ore:" + OreDictionary.getOreName((int)id))) continue;
            return inputs.get("ore:" + OreDictionary.getOreName((int)id)).floatValue();
        }
        return 0.0f;
    }

    static {
        inputs = new HashMap<String, Float>();
        outputs = new ArrayList<String>();
    }
}

