/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.block;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import svenhjol.charm.Charm;
import svenhjol.charm.base.CharmSounds;
import svenhjol.charm.crafting.feature.Barrel;
import svenhjol.charm.crafting.tile.TileBarrel;
import svenhjol.meson.MesonBlock;
import svenhjol.meson.MesonBlockTE;
import svenhjol.meson.iface.IMesonBlock;
import vazkii.quark.api.IRotationLockHandler;

@Optional.Interface(iface="vazkii.quark.api.IRotationLockHandler", modid="quark")
public class BlockBarrel
extends MesonBlockTE<TileBarrel>
implements IMesonBlock,
IRotationLockHandler {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    public static PropertyEnum<MesonBlock.WoodVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", MesonBlock.WoodVariant.class);

    public BlockBarrel() {
        super(Material.field_151575_d, "barrel");
        this.func_149711_c(Barrel.hardness);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    @Override
    public String getModId() {
        return "charm";
    }

    @Override
    public String[] getVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (MesonBlock.WoodVariant variant : MesonBlock.WoodVariant.values()) {
            variants.add(variant.toString().toLowerCase());
        }
        return variants.toArray(new String[0]);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileBarrel barrel = (TileBarrel)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (this.validTileEntity(barrel)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            barrel.setFacing(facing);
            barrel.setName(stack.func_82833_r());
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileBarrel barrel = (TileBarrel)this.getTileEntity((IBlockAccess)worldIn, pos);
            if (!this.validTileEntity(barrel)) {
                return false;
            }
            if (playerIn.func_70093_af()) {
                return false;
            }
            if (barrel.hasLootTable()) {
                barrel.generateLoot(playerIn);
            }
            playerIn.openGui((Object)Charm.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (worldIn.field_72995_K && !playerIn.func_70093_af()) {
            playerIn.func_184185_a(CharmSounds.WOOD_OPEN, 1.0f, 1.0f);
        }
        return true;
    }

    public IBlockState setRotation(World world, BlockPos pos, IBlockState state, EnumFacing facing, boolean hasHalf, boolean topHalf) {
        TileBarrel barrel = (TileBarrel)this.getTileEntity((IBlockAccess)world, pos);
        if (this.validTileEntity(barrel)) {
            barrel.setFacing(facing);
        }
        state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        world.func_180501_a(pos, state, 2);
        return state;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack thisBarrel = new ItemStack((Block)this, 1, this.func_176201_c(state));
        TileBarrel barrel = (TileBarrel)this.getTileEntity(world, pos);
        if (this.validTileEntity(barrel)) {
            this.dropsInventory(barrel, 27, (World)world, pos);
            thisBarrel.func_151001_c(barrel.getName());
        }
        drops.add((Object)thisBarrel);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 50;
    }

    @Override
    public Class<TileBarrel> getTileEntityClass() {
        return TileBarrel.class;
    }

    @Override
    @Nullable
    public TileBarrel createTileEntity(World world, IBlockState state) {
        return new TileBarrel();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)MesonBlock.WoodVariant.byMetadata(meta))).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public int func_176201_c(IBlockState state) {
        return ((MesonBlock.WoodVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)MesonBlock.WoodVariant.byMetadata(meta)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileBarrel barrel = (TileBarrel)worldIn.func_175625_s(pos);
        if (barrel != null && this.validTileEntity(barrel)) {
            EnumFacing facing = barrel.getFacing();
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                facing = EnumFacing.UP;
            }
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return state;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(world.func_180495_p(pos)));
    }
}

